---
title: Astro · Cloudflare Workers docs
description: Create an Astro application and deploy it to Cloudflare Workers
  with Workers Assets.
lastUpdated: 2025-09-02T14:27:46.000Z
chatbotDeprioritize: false
tags: SSG,Full stack,Astro
source_url:
  html: https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/
  md: https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/index.md
---

**Start from CLI**: Scaffold an Astro project on Workers, and pick your template.

* npm

  ```sh
  npm create cloudflare@latest -- my-astro-app --framework=astro
  ```

* yarn

  ```sh
  yarn create cloudflare my-astro-app --framework=astro
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest my-astro-app --framework=astro
  ```

***

**Or just deploy**: Create a static blog with Astro and deploy it on Cloudflare Workers, with CI/CD and previews all set up for you.

[![Deploy to Workers](https://deploy.workers.cloudflare.com/button)](https://dash.cloudflare.com/?to=/:account/workers-and-pages/create/deploy-to-workers\&repository=https://github.com/cloudflare/templates/tree/main/astro-blog-starter-template)

## What is Astro?

[Astro](https://astro.build/) is a JavaScript web framework designed for creating websites that display large amounts of content (such as blogs, documentation sites, or online stores).

Astro emphasizes performance through minimal client-side JavaScript - by default, it renders as much content as possible at build time, or [on-demand](https://docs.astro.build/en/guides/on-demand-rendering/) on the "server" - this can be a Cloudflare Worker. [“Islands”](https://docs.astro.build/en/concepts/islands/) of JavaScript are added only where interactivity or personalization is needed.

Astro is also framework-agnostic, and supports every major UI framework, including React, Preact, Svelte, Vue, SolidJS, via its official [integrations](https://astro.build/integrations/).

## Deploy a new Astro project on Workers

1. **Create a new project with the create-cloudflare CLI (C3).**

   * npm

     ```sh
     npm create cloudflare@latest -- my-astro-app --framework=astro
     ```

   * yarn

     ```sh
     yarn create cloudflare my-astro-app --framework=astro
     ```

   * pnpm

     ```sh
     pnpm create cloudflare@latest my-astro-app --framework=astro
     ```

   What's happening behind the scenes?

   When you run this command, C3 creates a new project directory, initiates [Astro's official setup tool](https://docs.astro.build/en/tutorial/1-setup/2/), and configures the project for Cloudflare. It then offers the option to instantly deploy your application to Cloudflare.

2. **Develop locally.**

   After creating your project, run the following command in your project directory to start a local development server.

   * npm

     ```sh
     npm run dev
     ```

   * yarn

     ```sh
     yarn run dev
     ```

   * pnpm

     ```sh
     pnpm run dev
     ```

3. **Deploy your project.**

   You can deploy your project to a [`*.workers.dev` subdomain](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/) or a [custom domain](https://developers.cloudflare.com/workers/configuration/routing/custom-domains/) from your local machine or any CI/CD system (including [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/#workers-builds)). Use the following command to build and deploy. If you're using a CI service, be sure to update your "deploy command" accordingly.

   * npm

     ```sh
     npm run deploy
     ```

   * yarn

     ```sh
     yarn run deploy
     ```

   * pnpm

     ```sh
     pnpm run deploy
     ```

## Deploy an existing Astro project on Workers

### If you have a static site

If your Astro project is entirely pre-rendered, follow these steps:

1. **Add a Wrangler configuration file**

   In your project root, create a Wrangler configuration file with the following content:

   * wrangler.jsonc

     ```jsonc
     {
       "name": "my-astro-app",
       "compatibility_date": "2025-10-23",
       "assets": {
         "directory": "./dist"
       }
     }
     ```

   * wrangler.toml

     ```toml
     name = "my-astro-app"
     compatibility_date = "2025-10-23"


     [assets]
     directory = "./dist"
     ```

   What's this configuration doing?

   The key part of this config is the `assets` field, which tells Wrangler where to find your static assets. In this case, we're telling Wrangler to look in the `./dist` directory. If your assets are in a different directory, update the `directory` value accordingly. Read about other [asset configuration options](https://developers.cloudflare.com/workers/wrangler/configuration/#assets).

   Also note how there's no `main` field in this config - this is because you're only serving static assets, so no Worker code is needed for on demand rendering/SSR.

2. **Build and deploy your project**

   You can deploy your project to a [`*.workers.dev` subdomain](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/) or a [custom domain](https://developers.cloudflare.com/workers/configuration/routing/custom-domains/) from your local machine or any CI/CD system (including [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/#workers-builds)). Use the following command to build and deploy. If you're using a CI service, be sure to update your "deploy command" accordingly.

   * npm

     ```sh
     npx astro build
     ```

   * yarn

     ```sh
     yarn astro build
     ```

   * pnpm

     ```sh
     pnpm astro build
     ```

   - npm

     ```sh
     npx wrangler@latest deploy
     ```

   - yarn

     ```sh
     yarn wrangler@latest deploy
     ```

   - pnpm

     ```sh
     pnpm wrangler@latest deploy
     ```

### If your site uses on demand rendering

If your Astro project uses [on demand rendering (also known as SSR)](https://docs.astro.build/en/guides/on-demand-rendering/), follow these steps:

1. **Install the Astro Cloudflare adapter**

   * npm

     ```sh
     npx astro add cloudflare
     ```

   * yarn

     ```sh
     yarn astro add cloudflare
     ```

   * pnpm

     ```sh
     pnpm astro add cloudflare
     ```

   What's happening behind the scenes?

   This command installs the Cloudflare adapter and makes the appropriate changes to your `astro.config.mjs` file in one step. By default, this sets the build output configuration to `output: 'server'`, which server renders all your pages by default. If there are certain pages that *don't* need on demand rendering/SSR, for example static pages like a privacy policy, you should set `export const prerender = true` for that page or route to pre-render it. You can read more about the adapter configuration options [in the Astro docs](https://docs.astro.build/en/guides/integrations-guide/cloudflare/#options).

2. **Add a `.assetsignore` file** Create a `.assetsignore` file in your `public/` folder, and add the following lines to it:

   ```txt
   _worker.js
   _routes.json
   ```

3. **Add a Wrangler configuration file**

   In your project root, create a Wrangler configuration file with the following content:

   * wrangler.jsonc

     ```jsonc
     {
       "name": "my-astro-app",
       "main": "./dist/_worker.js/index.js",
       // Update to today's date
       "compatibility_date": "2025-03-25",
       "compatibility_flags": ["nodejs_compat"],
       "assets": {
         "binding": "ASSETS",
         "directory": "./dist"
       },
       "observability": {
         "enabled": true
       }
     }
     ```

   * wrangler.toml

     ```toml
     name = "my-astro-app"
     main = "./dist/_worker.js/index.js"
     compatibility_date = "2025-03-25"
     compatibility_flags = [ "nodejs_compat" ]


     [assets]
     binding = "ASSETS"
     directory = "./dist"


     [observability]
     enabled = true
     ```

   What's this configuration doing?

   The key parts of this config are:

   * `main` points to the entry point of your Worker script. This is generated by the Astro adapter, and is what powers your server-rendered pages.
   * `assets.directory` tells Wrangler where to find your static assets. In this case, we're telling Wrangler to look in the `./dist` directory. If your assets are in a different directory, update the `directory` value accordingly.

   Read more about [Wrangler configuration options](https://developers.cloudflare.com/workers/wrangler/configuration/) and [asset configuration options](https://developers.cloudflare.com/workers/wrangler/configuration/#assets).

4. **Build and deploy your project**

   You can deploy your project to a [`*.workers.dev` subdomain](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/) or a [custom domain](https://developers.cloudflare.com/workers/configuration/routing/custom-domains/) from your local machine or any CI/CD system (including [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/#workers-builds)). Use the following command to build and deploy. If you're using a CI service, be sure to update your "deploy command" accordingly.

   * npm

     ```sh
     npx astro build
     ```

   * yarn

     ```sh
     yarn astro build
     ```

   * pnpm

     ```sh
     pnpm astro build
     ```

   - npm

     ```sh
     npx wrangler@latest deploy
     ```

   - yarn

     ```sh
     yarn wrangler@latest deploy
     ```

   - pnpm

     ```sh
     pnpm wrangler@latest deploy
     ```

## Bindings

Note

You cannot use bindings if you're using Astro to generate a purely static site.

With bindings, your Astro application can be fully integrated with the Cloudflare Developer Platform, giving you access to compute, storage, AI and more. Refer to the [bindings overview](https://developers.cloudflare.com/workers/runtime-apis/bindings/) for more information on what's available and how to configure them.

The [Astro docs](https://docs.astro.build/en/guides/integrations-guide/cloudflare/#cloudflare-runtime) provide information about how you can access them in your `locals`.

## Astro's build configuration

The Astro Cloudflare adapter sets the build output configuration to `output: 'server'`, which means all pages are rendered on-demand in your Cloudflare Worker. If there are certain pages that *don't* need on demand rendering/SSR, for example static pages such as a privacy policy, you should set `export const prerender = true` for that page or route to pre-render it. You can read more about on-demand rendering [in the Astro docs](https://docs.astro.build/en/guides/on-demand-rendering/).

If you want to use Astro as a static site generator, you do not need the Astro Cloudflare adapter. Astro will pre-render all pages at build time by default, and you can simply upload those static assets to be served by Cloudflare.
