---
title: Return small HTML page · Cloudflare Workers docs
description: Deliver an HTML page from an HTML string directly inside the Worker script.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python,Rust
source_url:
  html: https://developers.cloudflare.com/workers/examples/return-html/
  md: https://developers.cloudflare.com/workers/examples/return-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/return-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwA2ACwB2AMyTBARlkAmAKziAXCxZtgHOFxp8BIidLmKVAWABQAYXRUIAU3vYAIlADOMdO6jQ7qki08AmISKjhgBwYAIigaBwAPADoAK3do0lQoMCcIqNj45LToq1t7JwhsABU6GAcAuBgYMD4CKDtkFLgANzh3XgRYCABqYHRccAcrK0SvJBJcB1Q4cAgSAG9LEhI+uipeQIcIXgALAAoEBwBHEAd3CABKDa3tkl47e5ITiGAwEgYSAADAA8AEIXAB5axVACaAAUAKJfH5gAB8L22wIouDo6Ner2BJ1kqIAEg4wGB0CQAOqYMC4YHIIl4-EkYEwVFVE4eEjARAAaxAMBIAHc+iQAOZOBwIAgOXDkOg7EjWSkgXCoMCIBw0zD8mVJRkcjFs5DY3GAoiWE2XCAgBBUMIOEUkABKdy8VHcDjO31+ABpnqyvg44IsEO4Aptg9tou9ys4ILUHNEAtFHAkUH6wERTohvRAGABVKoAMWwAA5ov6TdsAL41-F1h5W+s1utEKwaZhaHR6Hj8IRiKQyeTKcSlOyOZxuTzeXztKgBII6UjhSIxSKEHQZQLZXIb6JkSlkEo2KcVarJhpNFq8NodNJ2aaWdbRPlxAD6YwmOVTBUWIp0jrLtu17EJ+wMIdjFHMxxGYIA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          html = """<!DOCTYPE html>
          <body>
            <h1>Hello World</h1>
            <p>This markup was generated by a Cloudflare Worker.</p>
          </body>"""


          headers = {"content-type": "text/html;charset=UTF-8"}
          return Response(html, headers=headers)
  ```

* Rust

  ```rs
  use worker::*;


  #[event(fetch)]
  async fn fetch(_req: Request, _env: Env, _ctx: Context) -> Result<Response> {
      let html = r#"<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>
      "#;
      Response::from_html(html)
  }
  ```

* Hono

  ```ts
  import { Hono } from "hono";
  import { html } from "hono/html";


  const app = new Hono();


  app.get("*", (c) => {
    const doc = html`<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker with Hono.</p>
      </body>`;


    return c.html(doc);
  });


  export default app;
  ```
