---
title: Tutorials · Cloudflare Workers AI docs
description: View tutorials to help you get started with Workers AI.
lastUpdated: 2025-09-16T10:05:45.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/workers-ai/guides/tutorials/
  md: https://developers.cloudflare.com/workers-ai/guides/tutorials/index.md
---

View tutorials to help you get started with Workers AI.

## Docs

| Name | Last Updated | Type | Difficulty |
| - | - | - | - |
| [Whisper-large-v3-turbo with Cloudflare Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-workers-ai-whisper-with-chunking/) | 7 months ago | 📝 Tutorial | Beginner |
| [Llama 3.2 11B Vision Instruct model on Cloudflare Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/llama-vision-tutorial/) | 9 months ago | 📝 Tutorial | Beginner |
| [Store and Catalog AI Generated Images with R2 (Part 3)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog/) | 9 months ago | 📝 Tutorial | Beginner |
| [Build a Retrieval Augmented Generation (RAG) AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai/) | 11 months ago | 📝 Tutorial | Beginner |
| [Using BigQuery with Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/using-bigquery-with-workers-ai/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Add New AI Models to your Playground (Part 2)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels/) | about 1 year ago | 📝 Tutorial | Beginner |
| [How to Build an Image Generator using Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Build an AI Image Generator Playground (Part 1)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Use event notification to summarize PDF files on upload](https://developers.cloudflare.com/r2/tutorials/summarize-pdf/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Explore Workers AI Models Using a Jupyter Notebook](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-workers-ai-models-using-a-jupyter-notebook/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Fine Tune Models With AutoTrain from HuggingFace](https://developers.cloudflare.com/workers-ai/guides/tutorials/fine-tune-models-with-autotrain/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Explore Code Generation Using DeepSeek Coder Models](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-code-generation-using-deepseek-coder-models/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Choose the Right Text Generation Model](https://developers.cloudflare.com/workers-ai/guides/tutorials/how-to-choose-the-right-text-generation-model/) | over 1 year ago | 📝 Tutorial | Beginner |

Developer Spotlight tutorials

Cloudflare's Developer Spotlight program has ended.

To view archived tutorials, refer to [Developer Spotlight](https://developers.cloudflare.com/developer-spotlight/).

## Videos

Also, explore our video resources on Workers AI:

OpenAI Relay Server on Cloudflare Workers

In this video, Craig Dennis walks you through the deployment of OpenAI's relay server to use with their realtime API.

Cloudflare Workflows | Introduction (Part 1 of 3)

In this video, we introduce Cloudflare Workflows, the Newest Developer Platform Primitive at Cloudflare.

Cloudflare Workflows | Batching and Monitoring Your Durable Execution (Part 2 of 3)

Workflows exposes metrics such as execution, error rates, steps, and total duration!

Building Front-End Applications | Now Supported by Cloudflare Workers

You can now build front-end applications, just like you do on Cloudflare Pages, but with the added benefit of Workers.

Build a private AI chatbot using Meta's Llama 3.1

In this video, you will learn how to set up a private AI chat powered by Llama 3.1 for secure, fast interactions, deploy the model on Cloudflare Workers for serverless, scalable performance and use Cloudflare's Workers AI for seamless integration and edge computing benefits.

How to Build Event-Driven Applications with Cloudflare Queues

In this video, we demonstrate how to build an event-driven application using Cloudflare Queues. Event-driven system lets you decouple services, allowing them to process and scale independently.

Welcome to the Cloudflare Developer Channel

Welcome to the Cloudflare Developers YouTube channel. We've got tutorials and working demos and everything you need to level up your projects. Whether you're working on your next big thing or just dorking around with some side projects, we've got you covered! So why don't you come hang out, subscribe to our developer channel and together we'll build something awesome. You're gonna love it.

AI meets Maps | Using Cloudflare AI, Langchain, Mapbox, Folium and Streamlit

Welcome to RouteMe, a smart tool that helps you plan the most efficient route between landmarks in any city. Powered by Cloudflare Workers AI, Langchain and Mapbox. This Streamlit webapp uses LLMs and Mapbox off my scripts API to solve the classic traveling salesman problem, turning your sightseeing into an optimized adventure!

Use Vectorize to add additional context to your AI Applications through RAG

A RAG based AI Chat app that uses Vectorize to access video game data for employees of Gamertown.

Cloudflare Workers AI, Building a "Hello, World" AI App!

Cloudflare's Workers AI helps you add AI functionality to the apps you are building. In this video we show you how simple and straightforward it is to build the Hello World of AI apps in under 5 minutes.

Build a URL Shortener with an AI-based admin section

We are building a URL Shortener, shrty.dev, on Cloudflare. The apps uses Workers KV and Workers Analytics engine. Craig decided to build with Workers AI runWithTools to provide a chat interface for admins.

Tool Calling Also Known as Function Calling on Cloudflare Workers AI

Tool calling, also known as function calling, is a powerful concept that lets you build Large Language Model based applications that can perform actions and retrieve external information from defined tools.

API Roll (Father's Day)

This walks through how to use Workers AI with Hono and Zod to create a streaming pun generating API.

AI can see clearly now - Build Vision Apps on Cloudflare Workers AI

The LlaVa model is hosted on Cloudflare Workers AI. Which means you are an API call away from brand new powerful vision use cases in all of your applications.

Workers AI - Getting Started - Vanilla Chat App

Get started building AI apps on Cloudflare using Pages and the GitHub starter template for a Vanilla JavaScript Chat App.

Image Generation, Inpainting, and Vision Models

Is that person you are about to swipe right on, actually real? Are they AI Generated?

Learn AI Development (models, embeddings, vectors)

In this workshop, Kristian Freeman, Cloudflare Developer Advocate, teaches the basics of AI Development - models, embeddings, and vectors (including vector databases).
