---
title: Leaked credentials example mitigation rules · Cloudflare Web Application
  Firewall (WAF) docs
description: Examples of rules for mitigating requests containing leaked credentials.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/leaked-credentials/examples/
  md: https://developers.cloudflare.com/waf/detections/leaked-credentials/examples/index.md
---

## Rate limit suspicious logins with leaked credentials

Note

Access to the `cf.waf.credential_check.username_and_password_leaked` field requires a Pro plan or above.

[Create a rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/) using [account takeover (ATO) detection](https://developers.cloudflare.com/bots/additional-configurations/detection-ids/#account-takeover-detections) and leaked credentials fields to limit volumetric attacks from particular IP addresses, JA4 Fingerprints, or countries.

The following example rule applies rate limiting to requests with a specific [ATO detection ID](https://developers.cloudflare.com/bots/additional-configurations/detection-ids/#account-takeover-detections) (corresponding to `Observes all login traffic to the zone`) that contain a previously leaked username and password:

**When incoming requests match**:\
`(any(cf.bot_management.detection_ids[*] eq 201326593 and cf.waf.credential_check.username_and_password_leaked))`

**With the same characteristics**: *IP*

When rate exceeds:

* **Requests**: `5`
* **Period**: *1 minute*

## Challenge requests containing leaked credentials

Note

Access to the *User and Password Leaked* (`cf.waf.credential_check.username_and_password_leaked`) field requires a Pro plan or above.

[Create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) that challenges requests containing a previously leaked set of credentials (username and password).

* **Expression**: If you use the Expression Builder, configure the following expression:

  | Field | Operator | Value |
  | - | - | - |
  | User and Password Leaked | equals | True |

  If you use the Expression Editor, enter the following expression:

  ```txt
  (cf.waf.credential_check.username_and_password_leaked)
  ```

* **Action**: *Managed Challenge*

***
