---
title: Error 1020 · Cloudflare Support docs
description: This error indicates that access to the website is denied by a
  Cloudflare firewall rule.
lastUpdated: 2025-08-11T16:04:48.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1020/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1020/index.md
---

## Error 1020: Access denied

This error indicates that access to the website is denied by a Cloudflare firewall rule.

### Common cause

A client or browser is blocked by a Cloudflare customer's Firewall Rules (deprecated).

### Resolution

If you are not the website owner, provide the website owner with a screenshot of the `1020` error message you received.

If you are the website owner:

1. Retrieve a screenshot of the 1020 error from your customer.
2. Search the [**Security Events log**](https://developers.cloudflare.com/waf/analytics/security-events/) (available at **Security** > **Events**) for the [**Ray ID**](https://developers.cloudflare.com/fundamentals/reference/cloudflare-ray-id/) or client IP Address from the visitor's 1020 error message.

Note

Convert the UTC timestamp of the `1020` error to your local timezone when searching in the **Security Events log**.

1. Assess the cause of the block and either update the **Firewall Rule** or allow the visitor's IP address in [**IP Access Rules**](https://developers.cloudflare.com/waf/tools/ip-access-rules/).
