---
title: Gathering information for troubleshooting sites · Cloudflare Support docs
description: It is important to capture as much information as possible to
  diagnose an issue and to provide adequate details to Cloudflare support. This
  article explains how to gather troubleshooting information commonly requested
  by Cloudflare Support.
lastUpdated: 2025-05-29T18:16:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/
  md: https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/index.md
---

## Overview

It is important to capture as much information as possible to diagnose an issue and to [provide adequate details to Cloudflare support](https://developers.cloudflare.com/support/contacting-cloudflare-support/). This article explains how to gather troubleshooting information commonly requested by Cloudflare Support.

Note

Cloudflare support cannot make configuration changes on behalf of customers due to security and liability concerns.

***

## Generate a HAR file

A HTTP Archive (HAR) records all web browser requests including the request and response headers, the body content, and the page load time. Be sure to use Incognito Mode or a Private Browsing window.

Warning

A HAR file can include sensitive details such as passwords, payment information, and private keys.

Remove sensitive information using a [HAR Sanitizer](https://har-sanitizer.pages.dev/).

For security reasons Cloudflare support cannot open compressed files such as ZIP, GZIP, TAR, etc.

Some browsers either require a browser extension or cannot generate a HAR. When installing a browser extension, follow the instructions from the extension provider.

### In Chrome

1. In a browser page viewed in Incognito Mode, right-click anywhere and select **Inspect Element**.

2. The Chrome DevTools appear either at the bottom, or left side of the browser. Click the **Network** tab.

![HAR network tab screenshot from Chrome developer tools](https://developers.cloudflare.com/_astro/gathering_har_file_network.ChkQZzBt_Z9Lfla.webp)

1. Check **Preserve log**. Please also check **Disable cache** if you are reporting a Cloudflare Cache issue.

2. Click record.

![HAR record button in chrome dev tools.](https://developers.cloudflare.com/_astro/gathering_har_file_record.BkFUFIPY_1s5pYP.webp)

1. Browse to the URL that causes issues. Once the issue is experienced, click the "Export HAR" option at the top of DevTools.

![export HAR option in Chrome DevTools](https://developers.cloudflare.com/_astro/export_har_chrome.DaDwwlXd_1W5V3K.webp)

1. Attach the HAR file to your support ticket.

Note

As of Chrome 130, this exports a sanitized HAR with redacted cookies and personalised data. To disable this, go to DevTools **Settings** > **Preferences** > **Network** > **Allow to generate HAR with sensitive data**.

### In Firefox

1. While using a Private Window, use the application menu and select **Tools** > **Web Developer** > **Network** or press *Ctrl+Shift+I* (Windows/Linux) or *Cmd+Option+I* (OS X).

2. Browse to the URL that causes issues.

3. After duplicating the issue, right-click and choose **Save All As HAR**.

### In Microsoft Edge

1. In a Private window, navigate to **Developer tools** (use `F12` as a shortcut) and select the **Network** tab.

2. Browse to the URL that causes issues.

3. After duplicating the issue, click on **Export as HAR** followed by **Save As...**.

### In Safari

1. In Safari, ensure a **Develop** menu appears at the top of a Private Window in the browser window. Otherwise, go to **Safari** > **Preferences** > **Advanced** and select **Show Develop Menu in menu bar**

2. Navigate to **Develop** > **Show Web Inspector**.

3. Browse to the URL that causes issues.

4. Ctrl + click on a resource within Web Inspector and click **Export HAR**.

### In Mobile

**For Android:**

1. Enable USB Debugging mode on your mobile device.

2. Go to `chrome://inspect/#devices`.

3. If debugging mode is enabled, you will see your device listed below “Remote Target” like the example below:

![Where to find the Inspect Devices when in Debug Mode for Android.](https://developers.cloudflare.com/_astro/step_1.BKH5ksch_Z19HRwr.webp)

1. Type in the URL, select **Open** and **inspect** to open Chrome’s DevTools.

2. Select the **Network** tab in the DevTools window.

3. Check **Preserve log**. Please also check ***Disable cache*** if you are reporting a Cloudflare Cache issue.

4. Click **record**.

![Where to find the record button in Chrome's dev tools.](https://developers.cloudflare.com/_astro/step_2_-_better.CJPZfMsT_1mwlPs.webp)

1. Browse to the URL that causes issues. Once the issue is experienced, right-click on any of the items within the **Network** tab and select **Save all as HAR with Content**.

![How to save HAR content. ](https://developers.cloudflare.com/_astro/step_3.D5uw6wSa_1xy71.webp)

1. Attach the HAR file to your support ticket alongside a screen recording from the affected Samsung device. Instructions on how to do this from Samsung devices can be found in [Samsung's documentation here](https://www.samsung.com/au/support/mobile-devices/screen-recorder/).

***

**For iPhone:**

Refer to [Okta](https://support.okta.com/help/s/article/How-to-generate-a-HAR-capture-on-an-iOS-device?language=en_US) or [Apple's](https://developer.apple.com/library/archive/documentation/AppleApplications/Conceptual/Safari_Developer_Guide/GettingStarted/GettingStarted.html#//apple_ref/doc/uid/TP40007874-CH2-SW1) support article on how to generate a HAR file from an iOS device. Attach the HAR file to your support ticket alongside a screen recording from the affected iOS device. Apple devices now have [built-in screen recording functionality](https://support.apple.com/en-us/HT207935).

***

## Export Console Log

In certain situations when request is not issued or cancelled by the browser (for example, due to [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS)), we need to get JS console log output, in addition to the HAR file, to identify the root cause.

### In Chrome

1. Go to the **Console** tab from the DevTools bar.
2. Go to the Console Settings and select **Preserve Log**.
3. Leave the console open and perform the steps that reproduce the issue.
4. Right-click on any of the items within the **Console** tab and select **Save as** log file.
5. Attach the log file to your support ticket.

![How to find the console tab in Chrome's developer tools.](https://developers.cloudflare.com/_astro/console_snapshot.BshJeLnS_ZzrvXb.webp)

### In Firefox

1. Go to the **Console** tab from the Web Developer Tools bar.
2. Go to the Console Settings and select **Persist Log** and **Show Timestamps**.
3. Leave the console open and perform the steps that reproduce the issue.
4. Right click, **Select All** messages and **Export Visible Messages to File**.
5. Attach the log file to your support ticket.

### In Microsoft Edge

1. Go to the **Console** tab from the Developer Tools bar.
2. Go to the Console Settings and select **Preserve Log**.
3. Leave the console open and perform the steps that reproduce the issue.
4. Right click on any of the items within the **Console** tab and select **Save as** log file.
5. Attach the log file to your support ticket.

### In Safari

1. Go to the **Console** tab from the Web Inspector bar.
2. Tick the box **Preserve Log**.
3. Leave the console open and perform the steps that reproduce the issue.
4. Select all the messages, right click and **Save Selected** to a log file.
5. Attach the log file to your support ticket.

***

## Capture a NetLog dump

In some cases, in order to further troubleshoot issues related to protocols (errors such as `ERR_QUIC_PROTOCOL_ERROR`, `ERR_HTTP2_PROTOCOL_ERROR`, etc..) our Support team may ask you to provide a [NetLog dump](https://www.chromium.org/for-testers/providing-network-details/).

Warning

You can only generate a NetLog dump on the Google Chrome, Opera or Microsoft Edge browsers.

1. Open a new tab and enter the following depending on the browser you're using:

* `chrome://net-export`
* `edge://net-export`
* `opera://net-export`

1. Click the **Start Logging To Disk** button.
2. Reproduce the network problem in a different tab. (the `chrome://net-export/`, `edge://net-export/` or `opera://net-export` tab needs to stay open otherwise logging will automatically stop)
3. Click **Stop Logging** button.
4. Attach the log file to your support ticket.

***

## Identify the Cloudflare data center serving your request

[A map of our data centers](https://www.cloudflare.com/network-map) is listed on the [Cloudflare status page](https://www.cloudflarestatus.com/), sorted by continent. The three-letter code in the data center name is the [IATA code](http://en.wikipedia.org/wiki/IATA_airport_code) of the nearest major international airport. Determine the Cloudflare data center serving requests for your browser by visiting: `http://``_www.example.com_``/cdn-cgi/trace.`

Replace `www.example.com` with your domain and hostname. Note the `colo` field from the output.

***

## Troubleshoot requests with curl

[curl](https://curl.se/) is a command line tool for sending HTTP/HTTPS requests and is useful for troubleshooting:

* HTTP/HTTPS Performance
* HTTP Error Responses
* HTTP Headers
* APIs
* Comparing Server/Proxy Responses
* SSL Certificates

Note

If you are using Windows, you can find more details on how to use curl on Windows in our [Making API calls on Windows ](https://developers.cloudflare.com/fundamentals/api/how-to/make-api-calls/#making-api-calls-on-windows)article.

Run the following command to send a standard HTTP GET request to your website (replace `www.example.com` with your hostname):

```plaintext
curl -svo /dev/null http://www.example.com/
```

This example curl command returns output detailing the HTTP response and request headers but discards the page body output. curl output confirms the HTTP response and whether Cloudflare is currently proxying traffic for the site.

Note

Review the [curl command options](https://curl.se/docs/manpage.html) for additional functionality.

View the sections below for tips on troubleshooting HTTP errors, performance, caching, and SSL/TLS certificates:

### HTTP errors

When troubleshooting HTTP errors in responses from Cloudflare, test whether your origin caused the errors by sending requests directly to your origin web server. To troubleshoot HTTP errors, run a curl directly to your origin web server IP address (bypassing Cloudflare’s proxy):

```plaintext
curl -svo /dev/null http://example.com --connect-to ::203.0.113.34
```

Note

If you have multiple origin web servers, test each one to ensure there are no response differences. If you observe the issue when connecting directly to your origin web server, contact your hosting provider for assistance.

### Performance

curl measures latency or performance degradation for HTTP/HTTPS requests via the [`-w` or `--write-out` curl option](https://curl.haxx.se/docs/manpage.html#-w). The example curl below measures several performance vectors in the request transaction such as duration of the TLS handshake, DNS lookup, redirects, transfers, etc:

```plaintext
curl -svo /dev/null https://example.com/ -w "\nContent Type: %{content_type} \
\nHTTP Code: %{http_code} \
\nHTTP Connect:%{http_connect} \
\nNumber Connects: %{num_connects} \
\nNumber Redirects: %{num_redirects} \
\nRedirect URL: %{redirect_url} \
\nSize Download: %{size_download} \
\nSize Upload: %{size_upload} \
\nSSL Verify: %{ssl_verify_result} \
\nTime Handshake: %{time_appconnect} \
\nTime Connect: %{time_connect} \
\nName Lookup Time: %{time_namelookup} \
\nTime Pretransfer: %{time_pretransfer} \
\nTime Redirect: %{time_redirect} \
\nTime Start Transfer: %{time_starttransfer} \
\nTime Total: %{time_total} \
\nEffective URL: %{url_effective}\n" 2>&1
```

[Explanation of this timing output](https://blog.cloudflare.com/a-question-of-timing/) is found on the Cloudflare blog.

Note

As demonstrated in the preceding example, cleaner results are achieved by denoting a new line with `\n` before each variable. Otherwise, all metrics are displayed together on a single line.

### Caching

cURL helps review the HTTP response headers that influence caching. In particular, review several HTTP headers when troubleshooting Cloudflare caching:

* CF-Cache-Status
* Cache-Control/Pragma
* Expires
* Last-Modified
* s-maxage

Note

You can refer to the [Cloudflare Cache documentation](https://developers.cloudflare.com/cache/get-started/) for more details.

### SSL/TLS certificates

#### Reviewing Certificates with curl

The following curl command shows the SSL certificate served by Cloudflare during an HTTPS request (replace `www.example.com` with your hostname):

```sh
curl -svo /dev/null https://www.example.com/ 2>&1 | egrep -v "^{.*$|^}.*$|^* http.*$"
```

Note

`2\*>&1 | egrep -v "^{.*$|^}.*$|^\* http.\*$" \*` cleans and parses the TLS handshake and certificate information.

To display the origin certificate (assuming one is installed), replace `203.0.113.34` below with the actual IP address of your origin web server and replace `www.example.com` with your domain and hostname:

```sh
curl -svo /dev/null https://www.example.com --connect-to ::203.0.113.34 2>&1 | egrep -v "^{.*$|^}.*$|^* http.*$"
```

#### Testing TLS Versions

If troubleshooting browser support or confirming what TLS versions are supported, curl allows you to test a specific TLS version by adding the [--tlsv1.X](https://curl.se/docs/manpage.html#--tlsv10) and [--tls-max](https://curl.se/docs/manpage.html#--tls-max) options to your curl:

* `--tlsv1.0 --tls-max 1.0`
* `--tlsv1.1 --tls-max 1.1`
* `--tlsv1.2 --tls-max 1.2`
* `--tlsv1.3 --tls-max 1.3`

***

## Temporarily pause Cloudflare

For more details, refer to [Pause Cloudflare](https://developers.cloudflare.com/fundamentals/manage-domains/pause-cloudflare/).

***

## Perform a traceroute

Traceroute is a network diagnostic tool that measures the route latency of packets across a network. Most operating systems support the `traceroute` command. If you experience connectivity issues with your Cloudflare-proxied website and [ask Cloudflare Support for assistance](https://developers.cloudflare.com/support/contacting-cloudflare-support/), ensure to provide output from a traceroute.

Note

Timeouts are possible for ping results because Cloudflare limits ping requests.

Review the instructions below for running traceroute on different operating systems. Replace `www.example.com` with your domain and hostname in the examples below:

### Run traceroute on Windows

1. Open the **Start** menu.

2. Click **Run**.

3. To open the command line interface, type **cmd** and then click **OK**.

4. At the command line prompt, type:

For IPv4 -

```sh
tracert www.example.com
```

For IPv6 -

```sh
tracert -6 www.example.com
```

1. Press **Enter**.

2. You can copy the results to save in a file or paste in another program.

### Run traceroute on Linux

1. Open a terminal window.

2. At the command line prompt, type:

For IPv4 -

```sh
traceroute www.example.com
```

For IPv6 -

```sh
traceroute -6 www.example.com
```

1. You can copy the results to save in a file or paste in another program.

### Run traceroute on Mac OS

1. Open the **Network Utility** application.
2. Click the **Traceroute** tab.
3. Type the *domain* or *IP address* in the appropriate input field and press **Trace**.
4. You can copy the results to save in a file or paste in another program.

Alternatively, follow the same Linux traceroute instructions above when using the Mac OS terminal program.

***

## Add the CF-RAY header to your logs

The **CF-RAY** header traces a website request through Cloudflare's network. Provide the **CF-RAY** of a web request to Cloudflare support when troubleshooting an issue. You can also add **CF-RAY** to your logs by editing your origin web server configuration with the snippet below that corresponds to your brand of web server:

### For Apache web servers, add `%{CF-Ray}i` to LogFormat

```plaintext
LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-agent}i\" %{CF-Ray}i" cf_custom
```

### For Nginx web servers, add '$http\_cf\_ray' to log\_format

```plaintext
log_format cf_custom '$remote_addr - $remote_user [$time_local] '
'"$request" $status $body_bytes_sent '
'"$http_referer" "$http_user_agent" '
'$http_cf_ray';
```

***

## Perform a MTR

Traceroute (MTR) is a tool that combines traceroute and ping, which is another common method for testing network connectivity and speed. In addition to the hops along the network path, MTR shows constantly updating information about the latency and packet loss along the route to the destination. This helps in troubleshooting network issues by allowing you to see what’s happening along the path in real-time.

MTR works by discovering the network path in a similar manner to traceroute, and then regularly sending packets to continue collecting information to provide an updated view into the network’s health and speed.

Like traceroute, MTR can use ICMP or UDP for outgoing packets but relies on ICMP for return (Type 11: Time Exceeded) packets.

Note

For MacOS users, MTR can be installed through [homebrew](https://formulae.brew.sh/formula/mtr). For Windows users, see [WinMTR](https://github.com/White-Tiger/WinMTR/releases).

### How do I use MTR to generate network path report?

**Using MTR on NIX based machines**

Generally, we'd use MTR as the following:

```sh
mtr -rw <dest_hostname> e.g.: mtr -rw one.one.one.one
```

or with destination IP:

```sh
mtr -rw <dest_IP> e.g.: mtr -rw 1.1.1.1
```

with TCP port

```sh
mtr -P <tcp port> -T <destination ip>
```

Please refer to this documentation, which explains more about analysing MTR: [How to read MTR](https://www.cloudflare.com/en-gb/learning/network-layer/what-is-mtr/).

***

## Run Packet Captures

**Why and when do you need Packet Captures?**

Issues that happen at the layers 3/4 occur before requests reaching Cloudflare's logging system, so they do not show up in the HTTP logs. Therefore, troubleshooting issues related to connection resets, packet loss or SSL handshake failures can be tricky without a deep investigation at the packet level.

Some HTTP errors generated by Cloudflare, such as [520s](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-520/), [524s](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-524/) and [525s](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-525/), show underlying issues at layers 3/4, and might require a packet capture for further investigation.

**How to Run a Packet Capture**

Warning

Please be aware, if you transmit any sensitive information while a packet capture is running, it will be recorded.

Cloudflare suggests [Wireshark](https://www.wireshark.org/download.html) for running packet captures. For instructions on how to use the *tcpdump* command line, refer to [this](https://www.wireshark.org/docs/wsug_html_chunked/AppToolstcpdump.html) article.

1. Close all programs/browser tabs that could be sending data in the background to avoid having to use a lot of display filters later.
2. Create your Wireshark capture filter (refer to [this](https://wiki.wireshark.org/CaptureFilters) article for more information).
3. Select the appropriate interface (e.g. Wi-Fi: en0). If you're not sure which interface to use, Wireshark provides an I/O graph of each interface to give you a hint.
4. Click the blue shark fin icon in the top left-hand corner to start your packet capture.
5. Reproduce the issue while running capture.
6. Click the red square icon in the top left-hand corner to stop your packet capture.
7. Save as a `.pcap` file and attach it to your support ticket.

***

## Related resources

* [Contacting Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/)
* [Cloudflare HTTP 5XX errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/)
* [Diagnosing network issues with MTR and traceroute](https://www.cloudflare.com/en-gb/learning/network-layer/what-is-mtr/)
* [cURL command line tool](https://curl.haxx.se/)
