---
title: Video · Cloudflare Style Guide
description: This document serves as a guide for producing Developer
  Documentation videos that uphold our standards for quality, consistency, and
  alignment with Cloudflare's brand identity and communication style.
lastUpdated: 2025-06-02T09:00:55.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/video/
  md: https://developers.cloudflare.com/style-guide/video/index.md
---

This document serves as a guide for producing Developer Documentation videos that uphold our standards for quality, consistency, and alignment with Cloudflare's brand identity and communication style.

Intended audiences include, but are not limited to:

* Cloudflare video teams to ensure high quality and consistency with each production.
* External production crews to streamline alignment on camera settings and exporting formats.

## Production

This section covers requirements, formatting, and settings for video, audio, color grading, and screen recording.

### Video Quality

#### Resolution

Videos should be recorded at 4K UHD. If 4K UHD is unavailable, Full HD footage may be accepted on a case-by-case basis. Footage below Full HD will not be used. Final video exports must be at least Full HD.

##### Acceptable Resolutions

* **4K Ultra HD:** 2160p (3840x2160)
* **2K Quad HD:** 1440p (2560x1440)
* **Full HD:** 1080p (1920x1080)

##### Unacceptable Resolutions

* **HD:** 720p (1280x720)
* **SD:** 480p (720x480)

#### Frame Rate

25 frames per second (FPS)

#### Bitrate

Footage should be recorded in the highest possible bitrate available. This allows for better color, detail, and video quality in the final export. You should be able to adjust bitrate in your camera settings.

#### Picture Profiles

Cloudflare prefers S-Cinetone because it represents a cinematic style with natural tones, soft highlights, and balanced contrast and is designed to deliver film-like visuals straight out of the camera. If the camera doesn't have S-Cinetone, then avoid flat color profiles, like S-Log.

### Audio Quality

#### Microphone Placement

* **Shotgun microphones**: Place the microphone over your head, just outside of the frame.
* **Lavalier microphones**: Hide cords and cables, but the microphone can be visible.

#### Tips for avoiding common audio problems

##### Background Noise

Avoid locations with background noise (for example, fan, air-conditioning, chatters) and echo to the best of your ability.

##### Echo

Echo is extremely difficult to remove in post-production. Best practice is to avoid empty rooms, but if you must, soundproof your recording area by introducing sound-absorbing materials such as carpets, curtains, blankets, or foam panels. Test for echoes by clapping and listening for a "dampened" sound.

### Aspect Ratios

Aspect ratio is important for the viewing experience. The more a video fills the screen, the more immersive an experience it provides.

#### Desktop Aspect Ratio

The most common screens and online platforms, such as YouTube and Vimeo, use a 16:9 ratio, so the majority of videos should be produced in a 16:9 ratio.

#### Mobile Aspect Ratio

Social media platforms like Instagram or Facebook are typically accessed on mobile devices and usually require a 9x16 aspect ratio. Efficiency calls for a 1:1 aspect ratio, which works on all, but not as great.

### Color Grading

Final videos should be graded to natural colors. They shouldn't be over or under saturated or too heavily influenced in one color direction. Different skin tones, lighting situations, and preferences for the "vibe" will influence the settings.

#### **Examples of Poor Color Grading**

![Too dark](https://developers.cloudflare.com/_astro/too_dark.BJxbGEPH_Z2wbD4d.webp)

![Too cool](https://developers.cloudflare.com/_astro/too_warm_cool_1._jKl9kkF_nrf5X.webp)

![Too dark](https://developers.cloudflare.com/_astro/too_warm_cool_2.Czf_b1Vf_ZTVM2q.webp)

![Too dark](https://developers.cloudflare.com/_astro/too_warm_cool_3.Bf5bjVrs_23CaSF.webp)

#### **Examples of Good Color Grading**

![Warm tone](https://developers.cloudflare.com/_astro/warm_tone.Rd0Z5YWk_Z1mj5MV.webp)

![White Balanced](https://developers.cloudflare.com/_astro/white_balanced.Dmxy5h5Y_Z2s3TRq.webp)

#### Screen Recording Resolution

Screen recordings should be done on the largest monitor possible, with the highest resolution available to the recording software (minimum 1920x1080). Ensure that any text visible on your screen is large enough that it can be easily read in the final video.

Note

You may need to modify the zoom of the window you are recording or your monitor's resolution to make sure the visual displayed is visible and legible.

### Presenter

#### Frame

When setting up the presenter frame, the presenter should position themselves in the center of the shot with some distance from the wall behind them to create depth. They should ensure their eyeline is directly towards the lens, engaging with the audience, and avoid any reflections on their glasses that could distract from the presentation. This will help maintain a clear and professional look throughout the video.

#### Dress Code

To create the most professional and consistent appearance, please follow these dress code guidelines:

* Wear smart casual tops, like a Cloudflare T-shirt, polo, casual shirt, or sweater. Stick to solid, black and white, and jewel tones (for example, dark orange, emerald green, navy, burgundy).
* Avoid distracting patterns, accessories, or flashy jewelry.
* Do not wear non-affiliated branded clothing, especially from non-open-source companies.

### Room Atmosphere

For the best video quality, consider the following options for setting up your space:

* **Option A**: Choose a location with natural light and minimal (echo)\[/style-guide/video/#echo]. Add extra lighting if needed.
* **Option B**: Set up a green screen. Ensure proper lighting to minimize shadows for the cleanest background.

## Post-Production

This section explores how Cloudflare branding is applied to video components.

### Video Components

#### Cloudflare Logo Usage, Fonts, and Color Palette

Brand guidelines are well documented and publicly available [here](https://www.figma.com/proto/FYnURhxtrmhMG2z60kLeoh/Brand-Design-Guidelines-%2723?page-id=1013%3A1410\&type=design\&node-id=1140-1812\&t=n6tugqnuuZqU3IFl-0\&scaling=scale-down\&starting-point-node-id=1140%3A1812\&hide-ui=1).

Developer Documentation videos adhere to all brand guidelines.

#### Intro and Outro

Intros and outros are essential for structuring a video and guiding the audience through its content.

#### Transitions, Effects and Chapter Separators

Other components, such as transitions, effects, and chapter separators, should be used sparingly to maintain a professional and cohesive video presentation. When included, they must be subtle and have a clear purpose, enhancing the content rather than distracting from it. It is important to ensure that these elements align with the video's overall style and tone, preserving its intended look and feel without overwhelming or altering the core visual identity.

Chapter separators should be used thoughtfully to indicate key sections, such as steps in tutorials, different concepts being explained, or distinct functions being demonstrated. To maintain a smooth flow, limit these transitions to no more than one every 3+ minutes. This ensures the video remains engaging and avoids overwhelming the viewer with excessive interruptions while effectively segmenting the content for clarity.

#### On-Screen Audiovisual Content

When using on-screen audiovisual content, such as overlays, stock footage, audio tracks, graphics, or other video assets, it is essential to ensure that all necessary permissions have been obtained and documented. Always verify that the assets are licensed for use in your project and adhere to any restrictions specified by the license agreement. Avoid assets that require visual attribution.

#### Subtitles

In general, we rely on platform automatic subtitle generation (for example, YouTube, Cloudflare Stream). For high-quality productions, subtitles are reviewed manually to ensure accuracy and clarity.

##### Subtitle Specifications

* Subtitles are always published in English in **SubRip format (.srt)**.

* Guidelines for subtitles:

  * Maximum **45 characters per line**.
  * Split over **2 lines** when necessary.
  * Displayed for no longer than **10 seconds** per subtitle.

#### Lower Thirds

Contact the Cloudflare Video team for the most up-to-date lower thirds and chapter files.

### Video Tone

#### Thumbnail Picture

Thumbnails should be clear still images of the presenter. Avoid motion blur or exaggerated facial expressions. Ensure the title text is readable.

##### Music

To maintain a balanced audio mix, follow these guidelines for background music:

* Music should be about 20dB lower than speaking volume.
* Background music must be instrumental, ensuring it doesn't overpower the speaker.
