---
title: Available notifications · Cloudflare Style Guide
lastUpdated: 2025-03-06T20:33:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/available-notifications/
  md: https://developers.cloudflare.com/style-guide/components/available-notifications/index.md
---

## Components

## Notifications

```yaml
entries:
  - name: Expiring Access Service Token Alert
    audience: "[Access](/cloudflare-one/access-controls/policies/) customers who want to receive a notification when their service token is about to expire."
    availability: Purchase of Access
    associatedProducts: Cloudflare Access
    nextSteps: Extend the expiration date of the service token. For more details, refer to [Renew your service token](/cloudflare-one/identity/service-tokens/#renew-service-tokens).
    otherFilters: None.


  - name: Usage Based Billing
    audience: Customers who want to receive a notification when the usage of a product goes above a set level.
    availability: Professional plans or higher.
    associatedProducts: Billing
    nextSteps: Review your product usage and adjust the configuration and/or increase the alerting threshold.
    otherFilters: |-
      You can choose the product that you want to be notified about and the threshold that fires the notification. Thresholds depend on the product chosen.


      For example:


      * Argo Smart Routing has **Notify when total bytes of traffic exceeds** as a threshold.
      * Load Balancing has **Notify when total number of DNS Queries exceeds** as a threshold.


  - name: Bot Detection Alert
    audience: Enterprise customers who want to be notified when Cloudflare detects a spike in bot traffic on their zones.
    availability: Accounts with at least one Enterprise zone.
    associatedProducts: Bots
    nextSteps: Select the [Security Analytics](/waf/analytics/security-analytics/) link enclosed in the alert message. Contact support if additional advice is needed on how to investigate the attack further.
    otherFilters: None.
    additional_information: After an alert is created on the dashboard, it may take up to 30 minutes before sufficient data is available to begin detecting traffic anomalies. Verified bot traffic is excluded from bot alerts.


  - name: Custom Bot Detection Alert
    audience: Enterprise customers who want to be notified when Cloudflare detects a spike in bot traffic on their zones.
    availability: Accounts with at least one Enterprise zone.
    associatedProducts: Bots
    nextSteps: Select the [Security Analytics](/waf/analytics/security-analytics/) link enclosed in the alert message. Contact support if additional advice is needed on how to investigate the attack further.
    otherFilters: Refer to the [alert logic](/bots/reference/alerts/#alert-logic) for more information on additional filters or groupings.
    additional_information: |-
      After an alert is created on the dashboard, it may take up to 30 minutes before sufficient data is available to begin detecting traffic anomalies. Verified bot traffic is excluded from both basic and advanced bot alerts.


      Alerts with grouping could cause potential noise if you set them up for a high-traffic zone. Grouping alerts function as if you set up separate policies with a filter for each value. Alerts may trigger multiple values in the same group as long as the traffic for each value reaches the threshold of 200.


  - name: Brand Protection Alerts
    audience: Customers who want a summary of activity related to [Brand Protection](/security-center/brand-protection/).
    availability: Professional plans or higher.
    associatedProducts: Security Center
    nextSteps: Investigate and potentially block any suspicious domains that may be trying to impersonate your brand.
    otherFilters: You can set up Brand Protection Alerts on individual monitored queries. For more details, refer to [Brand Protection Alerts](/security-center/brand-protection/#brand-protection-alerts).


  - name: Brand Protection Digest
    audience: Customers who want a summary of activity related to [Brand Protection](/security-center/brand-protection/).
    availability: Professional plans or higher.
    associatedProducts: Security Center
    nextSteps: Investigate and potentially block any suspicious domains that may be trying to impersonate your brand.
    otherFilters: You can set up Brand Protection Digest on individual monitored queries. For more details, refer to [Brand Protection Alerts](/security-center/brand-protection/#brand-protection-alerts).


  - name: Logo Match Alerts
    audience: Customers who want to receive a notification when the [Brand Protection](/security-center/brand-protection/) system detects a new domain which is using the uploaded logo and might be infringing copyright.
    availability: Enterprise plans.
    associatedProducts: Security Center
    nextSteps: Review the domains and URLs that are potentially impersonating your brand.
    otherFilters: You can select the query that you want to be alerted on.


  - name: Security Insights
    audience: Customers who want to receive notifications based on security insights findings.
    availability: All Cloudflare plans.
    associatedProducts: Security Center
    nextSteps: Review the insight and decide whether you want to resolve it, archive it, or export it.
    otherFilters: You can select the insight(s) you want to be alerted on.


  - name: Maintenance Notification
    audience: Customers interested in knowing about planned [Cloudflare maintenance](/support/troubleshooting/disruptive-maintenance/) for specific data centers. The notification lets you know when maintenance has been scheduled, changed, or canceled on an entire point of presence.
    availability: All Cloudflare plans.
    associatedProducts: Cloudflare Status
    nextSteps: If the notification is announcing new scheduled maintenance, you may want to add the maintenance to your calendar. During these maintenance windows, you may experience a slight increase in latency to the edge location which is under maintenance.
    otherFilters: You can filter maintenance notifications for specific points of presence and updates (scheduled, changed, canceled).


  - name: Incident Alerts
    audience: Customers interested in knowing about Cloudflare incidents. The notification lets you know when Cloudflare incidents are created, updated, and resolved.
    availability: All Cloudflare plans.
    associatedProducts: Cloudflare Status
    nextSteps: Review your [analytics](/analytics/) page to see if your domain is impacted.
    otherFilters: |-
      You can filter incident alerts to specific impact levels (minor, major, critical).


      Additionally, incident alerts can be filtered to incidents affecting specific components. By default, incident alerts will trigger a notification for incident updates across all impact levels and components.


      The impact level and affected components of an incident may change as the incident progresses. A notification will only be sent if the configured filters match at the time of the incident update. Updates will not be sent retroactively.


  - name: Secondary DNS all Primaries Failing
    audience: Enterprise customers who have at least one secondary zone in their account and want to receive a notification if all of their primary nameservers are failing.
    availability: Purchase of Secondary DNS
    associatedProducts: DNS
    nextSteps: |-
      1. Confirm that your primary nameservers are up and running.
      2. Confirm that the [Access Control Lists (ACLs)](/dns/zone-setups/zone-transfers/access-control-lists/cloudflare-ip-addresses/) on your primary nameservers are configured correctly.
      3. Confirm that your primary nameservers are configured correctly in your Cloudflare account (correct IP, port, TSIG).


    otherFilters: None.


  - name: Secondary DNS Primaries Failing
    audience: Enterprise customers who have at least one secondary zone and want to receive a notification if at least one of their primary nameservers is failing while transfers from at least one other primary are still successful.
    availability: Purchase of Secondary DNS.
    associatedProducts: DNS
    nextSteps: |-
      1. Confirm that your primary nameservers are up and running.
      2. Confirm that the [Access Control Lists (ACLs)](/dns/zone-setups/zone-transfers/access-control-lists/cloudflare-ip-addresses/) on your primary nameservers are configured correctly.
      3. Confirm that your primary nameservers are configured correctly in your Cloudflare account (correct IP, port, TSIG).


    otherFilters: None.


  - name: Secondary DNS Successfully Updated
    audience: Enterprise customers who have at least one secondary zone in their account and want to receive a notification on successful zone transfers.
    availability: Purchase of Secondary DNS.
    associatedProducts: DNS
    nextSteps: No action needed. Everything is working correctly.
    otherFilters: None.


  - name: Secondary DNS Warning
    audience: Customers who are using Cloudflare for Secondary DNS and want to receive notifications about warnings issued by the transferred zone.
    availability: Enterprise plans.
    associatedProducts: DNS
    nextSteps: |-
      Actions for failure notifications will depend on the type of failure.


    otherFilters: None.


  - name: HTTP DDoS Attack Alert
    audience: "[WAF](/waf/) or [CDN](/cache/) customers who want to receive a notification when Cloudflare has mitigated HTTP attacks that generate more than 100 requests per second."
    availability: All Cloudflare plans.
    associatedProducts: DDoS Protection
    nextSteps: No action needed. Refer to [DDoS alerts](/ddos-protection/reference/alerts/) for more information.
    otherFilters: None.


  - name: Layer 3/4 DDoS Attack Alert
    audience: "[BYOIP](/byoip/) and [Spectrum](/spectrum/) customers with [Network Analytics](/analytics/network-analytics/) who want to receive a notification when Cloudflare has mitigated attacks that generate an average of at least 12,000 packets per second over a five-second period, with a duration of one minute or more."
    availability: Purchase of Magic Transit and/or BYOIP.
    associatedProducts: DDoS Protection
    nextSteps: No action needed. Refer to [DDoS alerts](/ddos-protection/reference/alerts/) for more information.
    otherFilters: None.


  - name: Advanced HTTP DDoS Attack Alert
    audience: "[WAF](/waf/) or [CDN](/cache/) customers with the [Advanced DDoS Protection](/ddos-protection/) subscription who want to receive a notification when Cloudflare has mitigated attacks that generate more than the configured number of requests per second (100 rps by default)."
    availability: Enterprise plans with the Advanced DDoS Protection add-on.
    associatedProducts: DDoS Protection
    nextSteps: No action needed. Refer to [DDoS alerts](/ddos-protection/reference/alerts/) for more information.
    otherFilters: |-
      You can choose when to trigger a notification.


      Available filters include:


      * The zones in the account for which you wish to receive notifications.
      * The specific hostnames for which you wish to receive notifications.
      * The minimum requests-per-second rate that will trigger the alert (100 rps by default).


  - name: Advanced Layer 3/4 DDoS Attack Alert
    audience: "[BYOIP](/byoip/) and [Magic Transit](/magic-transit/) customers with [Network Analytics](/analytics/network-analytics/) who want to receive a notification when Cloudflare has mitigated attacks that generate more than the configured number of packets per second (12,000 pps by default)."
    availability: Purchase of Magic Transit and/or BYOIP (Enterprise plans).
    associatedProducts: DDoS Protection
    nextSteps: No action needed. Refer to [DDoS alerts](/ddos-protection/reference/alerts/) for more information.
    otherFilters: |-
      You can choose when to trigger a notification.


      Available filters include:


      * The IP prefixes for which you wish to receive notifications.
      * The specific IP addresses for which you wish to receive notifications.
      * The minimum packets-per-second rate that will trigger the alert (12,000 pps by default).
      * The minimum megabits-per-second rate that will trigger the alert.
      * The protocols for which you wish to receive notifications (all protocols by default).


      If you specify multiple filters, Cloudflare applies an `AND` logic. This means the alert will only trigger if all filters you set are true. Keep this in mind when setting up this alert with more than one filter.


  - name: Health Checks status notification
    audience: Customers who want to be warned about changes to server health as determined by [health checks](/health-checks/).
    availability: Professional plans or higher.
    associatedProducts: Health Checks
    nextSteps: Review your [health check analytics](/health-checks/health-checks-analytics/#common-error-codes).
    otherFilters: |-
      Available filters include:


      * You can search for and add health checks from your list of health checks.
      * You can choose a trigger to fire the notification when your server becomes **unhealthy**, **healthy**, or **either healthy or unhealthy**.


  - name: Pool Enablement
    audience: Customers who want to be warned about status changes (enabled/disabled) in their pools.
    availability: Purchase of [Load Balancing](/load-balancing/get-started/enable-load-balancing/).
    associatedProducts: Load Balancing
    nextSteps: No action is needed.
    otherFilters: |-
      Available filters include:


      * You can search for and add pools from your list of pools.
      * You can also choose the trigger that fires the notification when the Load Balancing pool is **enabled**, **disabled**, and **either enabled or disabled**.


  - name: Load Balancing Health Alert
    audience: Customers who want to be warned about [changes in health status](/load-balancing/understand-basics/health-details/) in their pools or origins.
    availability: Purchase of [Load Balancing](/load-balancing/get-started/enable-load-balancing/).
    associatedProducts: Load Balancing
    nextSteps: Evaluate [load balancing analytics](/load-balancing/reference/load-balancing-analytics/) to review changes in health status over time.
    otherFilters: |-
      Available filters include:


      * You can search for and add pools from your list of pools, as well as **Include future pools** (if all pools are selected).
      * You can choose the trigger that fires the notification when the health status becomes **unhealthy**, **healthy**, or **either unhealthy or healthy**
      * You can choose the trigger that fires the notification when the event source health status changes in **pool**, **origin**, or **either pool or origin**.


  - name: Failing Logpush Job Disabled
    audience: Enterprise customers who use [Logpush](/logs/) and want to monitor their job health.
    availability: Enterprise plans.
    associatedProducts: Logpush
    nextSteps: In the email for the notification, you can find the destination name for the failing Logpush job. With this destination name, you should be able to figure out which zone this relates to. There can be multiple reasons why a job fails, but it is best to test that the destination endpoint is healthy, and that necessary credentials are still working. You can also check that the destination has allowlisted [Cloudflare IPs](https://www.cloudflare.com/ips/).
    otherFilters: |-
      * Notification Name: A custom name for the notification.
      * Description (optional): A custom description for the notification.
      * Notification Email (can be multiple emails): The email address of the recipient for the notification.


  - name: Magic Network Monitoring - Auto Advertisement
    audience: "[Magic Transit on-demand](/magic-transit/on-demand/) customers who use Flow-Based Monitoring and want alerts when Magic Transit is automatically enabled."
    availability: Purchase of Magic Transit.
    associatedProducts: Magic Transit
    nextSteps: No action is needed. You can go to the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/magic-transit) to review the health and status of your tunnels.
    otherFilters: None.


  - name: Magic Network Monitoring - DDoS Attack
    audience: "[BYOIP](/byoip/) and [Spectrum](/spectrum/) customers with [Network Analytics](/analytics/network-analytics/) who want to receive a notification when Cloudflare has mitigated attacks that generate an average of at least 12,000 packets per second over a five-second period, with a duration of one minute or more."
    availability: Purchase of Magic Transit and/or BYOIP.
    associatedProducts: Magic Transit
    nextSteps: No action needed. Refer to [DDoS alerts](/ddos-protection/reference/alerts/) for more information.
    otherFilters: None.


  - name: Magic Network Monitoring - Volumetric Attack
    audience: "[Magic Transit on-demand](/magic-transit/on-demand/) customers who are using Flow-Based Monitoring to detect attacks when Magic Transit is disabled."
    availability: Purchase of Magic Transit.
    associatedProducts: Magic Transit
    nextSteps: If you do not have auto advertisement enabled, you need to advertise your IP prefixes to enable Magic Transit. For more information, refer to [Dynamic advertisement](/byoip/concepts/dynamic-advertisement/).
    otherFilters: None.


  - name: Magic Tunnel Health Check Alert
    audience: Magic Transit and Magic WAN customers who wish to receive alerts when the percentage of tunnel states meeting the selected service-level objective (SLO) drops below the defined threshold for a Magic Tunnel.
    availability: Purchase of Magic Transit and Magic WAN.
    associatedProducts: Magic Transit
    nextSteps: Refer to the [Magic Transit tunnel health](/magic-transit/network-health/check-tunnel-health-dashboard/) or [Magic WAN tunnel health](/magic-wan/configuration/common-settings/check-tunnel-health-dashboard/) for more information on what the issue might be.
    otherFilters: |-
      * Notification Name: A custom name for the notification.
      * Description (optional): A custom description for the notification.
      * Notification Email (can be multiple emails): The email address of recipient for the notification.
      * Webhooks
      * Tunnels: Choose one or more tunnels to monitor.
      * SLO: Define SLO threshold for Magic Tunnel health alerts. Available options are _High_, _Medium_, and _Low_.


  - name: Project updates
    audience: Customers who want to receive notifications about project-level events in [Cloudflare Pages](/pages/).
    availability: All Cloudflare plans.
    associatedProducts: Pages
    nextSteps: For failed deployments, review our [debugging guide](/pages/configuration/debugging-pages/#check-your-build-log).
    otherFilters: |-
      Available filters include:


      * Pages projects
      * Environments
      * Different events: **Deployment started**, **Deployment failed**, or **Deployment success**


  - name: Page Shield New Code Change Detection Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when JavaScript dependencies change in the pages of their domain."
    availability: Enterprise plans with paid add-on.
    associatedProducts: Page Shield
    nextSteps: Investigate to confirm that it is an expected change.
    otherFilters: None.
    additional_information: Triggered daily. If configured with a zone filter, the alert is triggered immediately.


  - name: Page Shield New Domain Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when resources from new host domains appear in their domain."
    availability: Business plans or higher.
    associatedProducts: Page Shield
    nextSteps: Investigate to confirm that it is an expected change.
    otherFilters: None.
    additional_information: Triggered hourly. If configured with a zone filter, the alert is triggered immediately.


  - name: Page Shield New Malicious Domain Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when resources from a known malicious domain appear in their domain. For more information, refer to [Malicious script and connection detection](/page-shield/how-it-works/malicious-script-detection/)."
    availability: Enterprise plans with paid add-on.
    associatedProducts: Page Shield
    nextSteps: |-
      Review the information in the Page Shield dashboard about the detected malicious resources, then update the pages where those resources were detected.


      For more information, refer to [Review scripts and connections considered malicious](/page-shield/detection/review-malicious-scripts/).
    otherFilters: None.


  - name: Page Shield New Malicious Script Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when Cloudflare classifies JavaScript dependencies in their domain as malicious. For more information, refer to [Malicious script and connection detection](/page-shield/how-it-works/malicious-script-detection/)."
    availability: Enterprise plans with paid add-on.
    associatedProducts: Page Shield
    nextSteps: |-
      Review the information in the Page Shield dashboard about the detected malicious resources, then update the pages where those resources were detected.


      For more information, refer to [Review scripts and connections considered malicious](/page-shield/detection/review-malicious-scripts/).
    otherFilters: None.


  - name: Page Shield New Malicious URL Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when resources from a known malicious URL appear in their domain. For more information, refer to [Malicious script and connection detection](/page-shield/how-it-works/malicious-script-detection/)."
    availability: Enterprise plans with paid add-on.
    associatedProducts: Page Shield
    nextSteps: |-
      Review the information in the Page Shield dashboard about the detected malicious resources, then update the pages where those resources were detected.


      For more information, refer to [Review scripts and connections considered malicious](/page-shield/detection/review-malicious-scripts/).
    otherFilters: None.


  - name: Page Shield New Resources Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when new resources appear in their domain."
    availability: Business plans or higher.
    associatedProducts: Page Shield
    nextSteps: Investigate to confirm that it is an expected change.
    otherFilters: None.
    additional_information: Triggered daily. If configured with a zone filter, the alert is triggered immediately.


  - name: Page Shield New Resource Exceeds Max URL Length Alert
    audience: "[Page Shield](/page-shield/) customers who want to receive a notification when a resource's URL exceeds the maximum allowed length."
    availability: Business plans or higher.
    associatedProducts: Page Shield
    nextSteps: Manually check the resource.
    otherFilters: None.


  - name: Radar Alerts
    audience: Customers who want to receive a notification when traffic anomalies, outages, route hijacks, or route leaks are impacting one or more countries, regions, or autonomous systems (ASNs) of interest.
    availability: All Cloudflare plans.
    associatedProducts: Radar
    nextSteps: Further action will depend on your role. Refer to the [Radar documentation](/radar/) for more information.
    otherFilters: |-
      Filters include:
      * Notification type (anomaly, outage, route hijack, route leak)
      * Location (country or region)
      * Autonomous systems (ASNs)


      You have the option to send the notification via email, webhook, or PagerDuty.


  - name: Route Leak Detection Alert
    audience: "[BYOIP customers](/byoip/) who want to receive a notification when their prefixes are advertised in places they should not be."
    availability: Purchase of BYOIP.
    associatedProducts: Route Leak Detection
    nextSteps: Confirm your traffic is healthy. Reach out to your transit providers to ensure you are behaving as expected and ask them to follow up with any providers accepting the unauthorized routes.
    otherFilters: None.


  - name: Access mTLS Certificate Expiration Alert
    audience: "[Access](/cloudflare-one/access-controls/policies/) customers that use client certificates for mutual TLS authentication. This notification will be sent 30 and 14 days before the expiration of the certificate."
    availability: Purchase of [Access](/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/) and/or [Cloudflare for SaaS](/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/enforce-mtls/).
    associatedProducts: SSL/TLS
    nextSteps: Upload a [renewed certificate](/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/#add-mtls-authentication-to-your-access-configuration).
    otherFilters: None.


  - name: Advanced Certificate Alert
    audience: Customers with [advanced certificates](/ssl/edge-certificates/advanced-certificate-manager/) that want to be alerted on validation, issuance, renewal, and expiration of certificates.
    availability: When an advanced certificate is validated, issued, renewed, or expired.
    associatedProducts: SSL/TLS
    nextSteps: Action only needed if notification is about a certificate that failed to be issued. Refer to [SSL expired or SSL mismatch errors](/ssl/troubleshooting/version-cipher-mismatch/) for more information.
    otherFilters: None.


  - name: Hostname-level Authenticated Origin Pulls Certificate Expiration Alert
    audience: |-
      Customers that upload their own certificate to use with hostname-level Authenticated Origin Pull (AOP) to secure connections from Cloudflare to their origin server.
      AOP certificate expiration notifications are sent 30 days and 14 days before the certificate expiry.
    availability: Authenticated Origin Pull.
    associatedProducts: SSL/TLS
    nextSteps: Upload a renewed certificate to use for [hostname-level AOP](/ssl/origin-configuration/authenticated-origin-pull/set-up/per-hostname/).
    otherFilters: None.


  - name: SSL for SaaS Custom Hostnames Alert
    audience: Customers with custom hostname certificates who want to receive a notification on validation, issuance, renewal, and expiration of certificates. For more details around data formatting for webhooks, refer to the [Cloudflare for SaaS docs](/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/webhook-definitions/).
    availability: Purchase of [Cloudflare for SaaS](/cloudflare-for-platforms/cloudflare-for-saas/).
    associatedProducts: SSL/TLS
    nextSteps: You only need to take action if you are notified that you have a certificate that failed. You can find the reasons why a certificate is not being issued in [Troubleshooting SSL errors](/ssl/troubleshooting/general-ssl-errors/).
    otherFilters: None.


  - name: Universal SSL Alert
    audience: Customers with universal certificates who want to receive a notification on validation, issuance, renewal, and expiration notices.
    availability: All Cloudflare plans.
    associatedProducts: SSL/TLS
    nextSteps: You only need to take action if you are notified that you have a certificate that failed. You can find the reasons why a certificate is not being issued in [Troubleshooting SSL errors](/ssl/troubleshooting/general-ssl-errors/).
    otherFilters: None.


  - name: Zone-level Authenticated Origin Pulls Certificate Expiration Alert
    audience: |-
      Customers that upload their own certificate to use with zone-level Authenticated Origin Pull (AOP) to secure connections from Cloudflare to their origin server.
      AOP certificate expiration notifications are sent 30 days and 14 days before the certificate expiry.
    availability: Authenticated Origin Pull.
    associatedProducts: SSL/TLS
    nextSteps: Upload a renewed certificate to use for [zone-level AOP](/ssl/origin-configuration/authenticated-origin-pull/set-up/).
    otherFilters: None.


  - name: mTLS Certificate Store Certificate Expiration Alert
    audience: |-
      Customers that upload their own client certificates for mTLS via [bring your own CA](/ssl/client-certificates/byo-ca/).


      This notification will be sent 30 and 14 days before the expiration of the certificate.
    availability: |-
      [Bring your own CA](/ssl/client-certificates/byo-ca/).


      The mTLS Certificate Store refers to customer uploaded certificates and does not include client certificates generated with the [Cloudflare CA](/ssl/client-certificates/#how-it-works).
    associatedProducts: SSL/TLS
    nextSteps: Upload a renewed certificate.
    otherFilters: None.


  - name: Stream Live Notifications
    audience: Customers who are using [Stream](/stream/) and want to receive webhooks with the status of their videos.
    availability: Stream subscription.
    associatedProducts: Stream
    nextSteps: Stream notifications are entirely customizable by the customer. Action will depend on the customizations enabled.
    otherFilters: |-
      You can input Stream Live IDs to receive notifications only about those inputs. If left blank, you will receive a list for all inputs.


      The following input states will fire notifications. You can toggle them on or off:


      * `live_input.connected`
      * `live_input.disconnected`


  - name: Advanced Error Rate Alert
    audience: Enterprise customers who want to receive a notification when Cloudflare detects edge and/or origin errors. Refer to [HTTP Traffic Alerts](/notifications/reference/traffic-alerts/) for more information.
    availability: Enterprise plans.
    associatedProducts: Traffic Monitoring
    nextSteps: |-
      1. Use the link in the notification you received to see which error codes Cloudflare is seeing.
      2. Depending on the statuses you are alerting on, refer to [Troubleshooting Cloudflare 5XX errors](/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/).
    otherFilters: |-
      Available filters include:


      * You can search and add domains from your list of domains.
      * You can filter alerts by **edge status code**, **origin status code**, and the **IP Address**.
      * You can also choose the trigger that fires the notification. Available triggers are **low sensitivity**, **medium sensitivity**, **high sensitivity**, or **very high sensitivity**.


      You can also toggle Alert Grouping to receive separate alerts for your domain, edge status code, and/or origin status code.
    limitations: |-
      Traffic Monitoring alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      These thresholds cannot be configured. Service level objectives (SLOs) are used to determine the threshold.


  - name: Origin Error Rate Alert
    audience: Enterprise customers who want to receive a notification when Cloudflare is unable to access their origin server. Refer to [HTTP Traffic Alerts](/notifications/reference/traffic-alerts/) for more information.
    availability: Enterprise plans.
    associatedProducts: Traffic Monitoring
    nextSteps: |-
      1. Use the link in the Notification you received to see which error codes Cloudflare is seeing from your origin.
      2. Refer to [Troubleshooting Cloudflare 5XX errors](/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/) to learn how to troubleshoot these errors.
    otherFilters: |-
      Multiple filters available:


      * You can search and add domains from your list of domains.
      * You can also choose the trigger that fires the notification. Available triggers are **low sensitivity**, **medium sensitivity**, **high sensitivity**, or **very high sensitivity**.
    limitations: |-
      Traffic Monitoring alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      These thresholds cannot be configured. Service level objectives (SLOs) are used to determine the threshold.


  - name: Passive Origin Monitoring
    audience: Customers who want to receive a notification when Cloudflare is unable to access their origin. Customers will only receive this notification when their origin is returning a `521` error.
    availability: All Cloudflare plans.
    associatedProducts: Traffic Monitoring
    nextSteps: Refer to [Troubleshooting Cloudflare 5XX errors](/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/) to learn how to troubleshoot these errors.
    otherFilters: None.
    limitations: |-
      Traffic Monitoring alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      For every account with this alert set up, you will not receive duplicate alerts within the same four-hour time frame. The alert received will contain the most recent set of origins returning 521s.


  - name: Traffic Anomalies Alert
    audience: Enterprise customers who want to receive a notification when one zone is experiencing an unexpected spike or drop in traffic. Refer to [HTTP Traffic Alerts](/notifications/reference/traffic-alerts/) for more information.
    availability: Enterprise plans.
    associatedProducts: Traffic Monitoring
    nextSteps: Use the link in the Notification you received to view if the spike or drop is significant enough to require further actions.
    otherFilters: |-
      Multiple filters available:


      * You can search and add domains from your list of domains.
      * You can include or exclude traffic mitigated by the [Web Application Firewall (WAF)](/waf/).
      * You can choose whether to be notified of either spikes or drops in traffic.
    limitations: |-
      Traffic Monitoring alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      These thresholds cannot be configured. Z-score is used to determine the threshold.


  - name: Block Review Rejection
    audience: Customers who want to be notified when Cloudflare Trust & Safety rejects a request for block removal.
    availability: All Cloudflare plans.
    associatedProducts: Trust and Safety Blocks
    nextSteps: Take care of any abuse on your website. Then, go to the [Cloudflare dashboard](https://dash.cloudflare.com/) and request a review.
    otherFilters: None.


  - name: New Blocks
    audience: Customers who want to be notified when Cloudflare Trust & Safety places a block on their website.
    availability: All Cloudflare plans.
    associatedProducts: Trust and Safety Blocks
    nextSteps: Take care of any abuse on your website. Then, go to the [Cloudflare dashboard](https://dash.cloudflare.com/) and request a review.
    otherFilters: None.


  - name: Removed Blocks
    audience: Customers who want to be notified when Cloudflare Trust & Safety removes a block from their website.
    availability: All Cloudflare plans.
    associatedProducts: Trust and Safety Blocks
    nextSteps: This is informational follow up.
    otherFilters: None.


  - name: Tunnel Creation or Deletion Event
    audience: Customers who want to receive a notification when Cloudflare Tunnels are created or deleted in their account.
    availability: All Cloudflare Zero Trust plans.
    associatedProducts: Tunnel
    nextSteps: No action is needed.
    otherFilters: None.


  - name: Tunnel Health Alert
    audience: Customers who want to be warned about changes in health status for their Cloudflare Tunnels.
    availability: All Cloudflare Zero Trust plans.
    associatedProducts: Tunnel
    nextSteps: Monitor tunnel health over time and consider deploying [`cloudflared` replicas or load balancers](/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/tunnel-availability/).
    otherFilters: None.
    additional_information: |-
      Refer to [Tunnel status](/cloudflare-one/networks/connectors/cloudflare-tunnel/troubleshoot-tunnels/common-errors/#tunnel-status) to review the list of possible tunnel statuses (`Active`, `Inactive`, `Down` and `Degraded`).


  - name: Device connectivity anomaly
    audience: Zero Trust customers who want to be notified when Cloudflare detects a spike or drop in the number of devices connected to the WARP client.
    availability: All Cloudflare Zero Trust plans.
    associatedProducts: DEX
    nextSteps: Review your [fleet status](/cloudflare-one/insights/dex/fleet-status/) to investigate why the spike or drop occurred and which devices are impacted.
    additional_information: To learn more about the alert logic, refer to [Z-score](/cloudflare-one/insights/dex/notifications/#z-score).
    otherFilters: |-
      - **Alert configuration**: Choose when to trigger a notification. Available options are _Connectivity spike_, _Connectivity drop_, and _Connectivity spike or drop_.
      - Filters:
        - **Colo**: Cloudflare data center that the device is connected to.
        - **Platform**: Operating system of the device.
        - **Version**: WARP client version (for example, `2024.3.409.0`).
        - **Mode**: [WARP mode](/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) deployed on the device.


  - name: DEX test latency
    audience: Zero Trust customers who wish to receive alerts when there is a spike or drop in application latency, as measured by the HTTP test [Resource Fetch time](/cloudflare-one/insights/dex/tests/http/#test-results) or Traceroute test [Round trip time](/cloudflare-one/insights/dex/tests/traceroute/#test-results). Requires setting up a [DEX test](/cloudflare-one/insights/dex/tests/).
    availability: All Cloudflare Zero Trust plans.
    associatedProducts: DEX
    nextSteps: View your [test results](/cloudflare-one/insights/dex/tests/view-results/) to investigate why the spike occurred.
    additional_information: To learn more about the alert logic, refer to [Z-score](/cloudflare-one/insights/dex/notifications/#z-score).
    otherFilters: |-
      - **Alert configuration**: Choose when to trigger a notification. Available options are _Latency spike_, _Latency drop_, and _Latency spike or drop_.
      - Filters:
        - **Colo**: Cloudflare data center that the device is connected to.
        - **Platform**: Operating system of the device.
        - **Version**: WARP client version (for example, `2024.3.409.0`).
        - **Test name**: Choose which DEX test the alert should monitor. You will receive individual notifications for each test.


  - name: DEX test low availability
    audience: Zero Trust customers who wish to receive alerts when the percentage of successful HTTP or traceroute requests to an application drops below the selected service-level objective (SLO). Requires setting up a [DEX test](/cloudflare-one/insights/dex/tests/).
    availability: All Cloudflare Zero Trust plans.
    associatedProducts: DEX
    nextSteps: View your [test results](/cloudflare-one/insights/dex/tests/view-results/) to investigate why the degradation occurred.
    additional_information: To learn more about the alert logic, refer to [SLO](/cloudflare-one/insights/dex/notifications/#slo).
    otherFilters: |-
      - **Service Level Objective (SLO)**: Specify the availability threshold that will trigger an alert. Enter a percentage in `xx.x` format (for example, `98.0`).
      - Filters:
        - **Colo**: Cloudflare data center that the device is connected to.
        - **Platform**: Operating system of the device.
        - **Version**: WARP client version (for example, `2024.3.409.0`).
        - **Test name**: Choose which DEX test the alert should monitor. You will receive individual notifications for each test.


  - name: Advanced Security Events Alert
    audience: Enterprise customers who want to receive alerts about spikes in specific services that generate log entries in [Security Events](/waf/analytics/security-events/). For more information, refer to [WAF alerts](/waf/reference/alerts/).
    availability: Enterprise plans.
    associatedProducts: Web Application Firewall (WAF)
    nextSteps: Review the information in [Security Events](/waf/analytics/security-events/) to identify any possible attack or misconfiguration.
    otherFilters: |-
      A mandatory [`filters`](/api/resources/alerting/subresources/policies/methods/create/) selection is needed when you create a notification policy which includes the list of services and zones that you want to be alerted on.


      * You can search for and add domains from your list of Enterprise zones.
      * You can choose which services the alert should monitor (Managed Firewall, Rate Limiting, etc.).
      * You can filter events by a targeted action.
    additional_information: |-
      The mean time to detection is five minutes.


      When setting up this alert, you can select the services that will be monitored. Each selected service is monitored separately and can be selected as a filter.
    limitations: |-
      Security Events (WAF) alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      These thresholds cannot be configured. Z-score is used to determine the threshold.


  - name: Security Events Alert
    audience: Business and Enterprise customers who want to receive alerts about spikes across all services that generate log entries in [Security Events](/waf/analytics/security-events/). For more information, refer to [WAF alerts](/waf/reference/alerts/).
    availability: Business and Enterprise plans.
    associatedProducts: Web Application Firewall (WAF)
    nextSteps: Review the information in [Security Events](/waf/analytics/security-events/) to identify any possible attack or misconfiguration.
    otherFilters: |-
      A mandatory [`filters`](/api/resources/alerting/subresources/policies/methods/create/) selection is needed when you create a notification policy which includes the list of zones that you want to be alerted on.


      * You can also search for and add domains from your list of business or enterprise zones. The notification will be sent for the domains chosen.
      * You can filter events by a targeted action.
    additional_information: |-
      The mean time to detection is five minutes.


      When setting up this alert, you can select the services that will be monitored. Each selected service is monitored separately.
    limitations: |-
      Security Events (WAF) alerts are not sent for each individual events, but only when a spike in traffic reaches the threshold for an alert to be sent.


      These thresholds cannot be configured. Z-score is used to determine the threshold.


  - name: Weekly summary
    audience: Customers using [Web Analytics](/web-analytics/) to monitor their website's performance.
    availability: All Cloudflare plans.
    associatedProducts: Web Analytics
    nextSteps: No action is needed. This notification is a weekly summary with reports from your Web Analytics account. Refer to [Notifications](https://dash.cloudflare.com/?to=/:account/notifications) in the Cloudflare dashboard to refine your notifications settings.
    otherFilters: None.


  - name: Image Notifications
    audience: Customers using [Direct creator uploads](/images/upload-images/direct-creator-upload/) to upload images.
    availability: Cloudflare images subscription.
    associatedProducts: Cloudflare Images
    nextSteps: No action is needed.
    otherFilters: None.


  - name: Image Transformation Notifications
    audience: Customers who are using free image transformations and want to be notified if they exceed their free quota.
    availability: All Cloudflare plans.
    associatedProducts: Cloudflare Images
    nextSteps: No action is needed.
    otherFilters: None.


  - name: Connection Maintenance Alert
    audience: "[Classic CNI](/network-interconnect/classic-cni/) customers who want to be alerted to maintenance events that might affect Classic CNI."
    availability: Purchase of Cloudflare Network Interconnect (CNI).
    associatedProducts: Network Interconnect
    nextSteps: No action is needed.
    otherFilters: None.
```
