---
title: Enable Total TLS · Cloudflare SSL/TLS docs
description: "To enable Total TLS - which issues individual certificates for
  your proxied hostnames - follow these instructions:"
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/enable/
  md: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/enable/index.md
---

To enable [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/) - which issues individual certificates for your proxied hostnames - follow these instructions:

* Dashboard

  To enable Total TLS in the dashboard:

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
  2. Choose your account and domain.
  3. Go to **SSL/TLS** > **Edge Certificates**.
  4. For **Total TLS**, switch the toggle to **On** and - if desired - choose an issuing **Certificate Authority**.

* API

  To enable Total TLS with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/acm/subresources/total_tls/methods/create/) request with the `enabled` parameter set to your desired setting (`true` or `false`).

  You can also specify a desired certificate authority by adding a value to the `certificate_authority` parameter.

## Aspects to consider

* Total TLS certificates follow the Common Name (CN) restriction of 64 characters ([RFC 5280](https://www.rfc-editor.org/rfc/rfc5280.html)). If you have a hostname that exceeds this length, you can create an [Advanced Certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/#create-a-certificate) via API to cover it.
