---
title: Tutorials · Cloudflare Sandbox SDK docs
description: Learn how to build applications with Sandbox SDK through
  step-by-step tutorials. Each tutorial takes 20-30 minutes.
lastUpdated: 2025-10-21T14:02:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/tutorials/
  md: https://developers.cloudflare.com/sandbox/tutorials/index.md
---

Learn how to build applications with Sandbox SDK through step-by-step tutorials. Each tutorial takes 20-30 minutes.

[Build an AI code executor](https://developers.cloudflare.com/sandbox/tutorials/ai-code-executor/)

[Use Claude to generate Python code from natural language and execute it securely in sandboxes.](https://developers.cloudflare.com/sandbox/tutorials/ai-code-executor/)

[Automated testing pipeline](https://developers.cloudflare.com/sandbox/tutorials/automated-testing-pipeline/)

[Build a testing pipeline that clones Git repositories, installs dependencies, runs tests, and reports results.](https://developers.cloudflare.com/sandbox/tutorials/automated-testing-pipeline/)

[Analyze data with AI](https://developers.cloudflare.com/sandbox/tutorials/analyze-data-with-ai/)

[Upload CSV files, generate analysis code with Claude, and return visualizations.](https://developers.cloudflare.com/sandbox/tutorials/analyze-data-with-ai/)

[Build a code review bot](https://developers.cloudflare.com/sandbox/tutorials/code-review-bot/)

[Clone repositories, analyze code with Claude, and post review comments to GitHub PRs.](https://developers.cloudflare.com/sandbox/tutorials/code-review-bot/)

## Before you start

All tutorials assume you have:

* Completed the [Get Started guide](https://developers.cloudflare.com/sandbox/get-started/)
* Basic familiarity with [Workers](https://developers.cloudflare.com/workers/)
* [Docker](https://www.docker.com/) installed and running

## Related resources

* [How-to guides](https://developers.cloudflare.com/sandbox/guides/) - Solve specific problems
* [API reference](https://developers.cloudflare.com/sandbox/api/) - Complete SDK reference
