---
title: Bulk Redirects FAQ · Cloudflare Rules docs
description: Below you will find answers to the most commonly asked questions
  regarding Bulk Redirects.
lastUpdated: 2025-09-11T15:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/faq/
  md: https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/faq/index.md
---

Below you will find answers to the most commonly asked questions regarding Bulk Redirects.

To troubleshoot errors related to Bulk Redirects:

* Refer to [Troubleshooting Cloudflare 10XXX Errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-10xxx-errors/) for more information on runtime errors.
* Use [Cloudflare Trace](https://developers.cloudflare.com/rules/trace-request/) to determine if a rule is triggering for a specific URL.

## What happens if the same source URL appears in two different Bulk Redirect Lists?

In this situation, Cloudflare will use the URL redirect of the first rule that triggers. This will be determined by the order of the Bulk Redirect Rules enabling each Bulk Redirect List in the `http_request_redirect` phase entry point ruleset.

## How can I solve the following error: "This account has reached the limit on the number of URL matching items on the same hostname/path"?

You may get this error when adding items to a Bulk Redirect List.

You can have any number of URL redirects with the same source hostname (with different paths) or same source path (with different hostnames). However, you can have a maximum of 16 source URLs with the same hostname and path across all lists, either enabled by a Bulk Redirect Rule or not.

If you receive this error, check if you have any unused Bulk Redirect Lists with the source hostname and path that caused the error, and remove such items from the list.

## How many URL redirects can I have in a single Bulk Redirect List?

Each account has a maximum number of URL redirects across all lists which depends on your Cloudflare plan. If you wish, you can use all the URL redirects available in your plan in a single Bulk Redirect List, but you will not be able to create any other URL redirects in a different list. Refer to [Availability](https://developers.cloudflare.com/rules/url-forwarding/#availability) for more information.

## How can I redirect based on the non-normalized version of a URL?

Use the `raw.http.request.full_uri` field both in the rule expression and in the key, instead of the default field `http.request.full_uri`. This will take the raw version of the URL into account, that is, the URL received on the Cloudflare global network before applying normalization. Refer to [Concepts: Bulk Redirect Rules](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/concepts/#bulk-redirect-rules) for more information on using a custom rule expression and a custom key.

## Do Bulk Redirects take precedence over Page Rules?

Yes. Bulk Redirects take precedence over Page Rules redirects. For more information on the execution order of Rules products, refer to [Execution order](https://developers.cloudflare.com/rules/url-forwarding/#execution-order).

## Can I purge an entire Bulk Redirect List in one API call?

If your [Bulk Redirect List](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/concepts/#bulk-redirect-lists) contains 500,001 or more items, you will not be able to purge the entire list in a single API call. Instead, you must make multiple calls to [Delete List Items](https://developers.cloudflare.com/api/resources/rules/subresources/lists/subresources/items/methods/delete/) API end-point, deleting a maximum of 100,000 items per request.

For example, to delete a list with 1,000,000 items, you would need to issue at least 10 API requests.
