---
title: Check tunnel health in the dashboard · Cloudflare Magic WAN docs
description: The Cloudflare dashboard monitors the health of all anycast tunnels
  on your account that route traffic from Cloudflare to your origin network.
lastUpdated: 2025-10-15T16:28:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/common-settings/check-tunnel-health-dashboard/
  md: https://developers.cloudflare.com/magic-wan/configuration/common-settings/check-tunnel-health-dashboard/index.md
---

The Cloudflare dashboard monitors the health of all anycast tunnels on your account that route traffic from Cloudflare to your origin network.

The dashboard shows the view of tunnel health as measured from each Cloudflare location where your traffic is likely to land. If the tunnels are healthy on your side, you will see the majority of servers reporting an **up** status. It is normal for a subset of these locations to show tunnel status as degraded or unhealthy, since the Internet is not homogeneous and intermediary path issues between Cloudflare and your network can cause interruptions for specific paths.

Note

To access more than one hour of tunnel health data, you should use the [GraphQL API](https://developers.cloudflare.com/magic-wan/analytics/query-tunnel-health/).

Not all data centers will be relevant to you at all times. You can refer to the **Average ingress traffic (last hour)** column to understand if a given data center is receiving traffic for your network, and if its health status is relevant to you.

Note

To change between the new dashboard experience and the old one, find the banner at the top of the screen.

To check for anycast tunnel health:

* Old dashboard

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.
  2. Go to **Magic WAN** > **Network health**.
  3. In **Cloudflare colos**, you can choose one or more Cloudflare data centers to filter out the traffic that shows up in your anycast tunnels. For example, if you chose the Lisbon data center, your anycast tunnels would only show connections to that data center.
  4. Below, you have a list of all your anycast tunnels, as well as their current health status. Find the tunnel you wish to inspect and select the arrow (**>**) before it to open its details.
  5. The details pane shows the connection status between different Cloudflare servers and your tunnel. Select **Traceroute for details** in one of the Cloudflare servers shown to check for issues between Cloudflare and your origin network.

* New dashboard

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.

  2. Go to **Magic WAN** > **Network health**.

  3. In the next screen you can access a list of your tunnels and their current health status. You can also check the amount of health checks passed in the last hour as well as traffic volume for each tunnel.

  4. Find the tunnel you wish to inspect, select the three dots in front of the tunnel and select:

     * **Create alert**: This will send you to the [notifications wizard](https://developers.cloudflare.com/magic-wan/configuration/common-settings/configure-magic-tunnel-health-alerts/) so you can create specific alerts for that tunnel, to be warned when specific conditions are met.
     * **Network Analytics**: This will send you to the Analytics section of the dash, prefiltered with the tunnel you want to inspect.

  5. Alternatively, from the list of tunnels, select the tunnel you want to inspect to access details about it.

## Check tunnel health for a specific tunnel

Beyond having a wide view into all connections, you can drill down into a specific tunnel to check its health status and other information. Refer to the blue note above to learn how to access the new dashboard experience, and:

1. Go to **Magic WAN** > **Network health**.
2. Find and select the tunnel you wish to inspect.

The next screen shows you detailed information about the tunnel, including:

* Status information

  * Up: More than 80% of health checks are passing.
  * Degraded: More than 40% of health checks are passing.
  * Down: Less than 40% of health checks are passing.

* Health checks passed in the last hour

* Traffic volume in the last hour

If you select the three dots in front of the tunnel you want to inspect, you have access to the following tools:

* Packet captures: Collect [packet level data for you traffic](https://developers.cloudflare.com/magic-firewall/packet-captures/)
* Network Analytics: Leverage real-time visibility into [network analytics](https://developers.cloudflare.com/magic-wan/analytics/network-analytics/).

Note

Magic WAN customers with [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/) enabled for the European Union are able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API. This ensures that any Magic WAN customers that need to be GDPR compliant are able to access all Magic WAN features.

## Magic WAN Connector

Magic WAN Connector also includes a heartbeat function, an additional way of communicating its health status which does not depend on successfully setting up any tunnels. The heartbeat function communicates periodically with Cloudflare via HTTPS and lets Cloudflare know that the Magic WAN Connector in question is connected to the Internet and reachable.

Refer to [Heartbeat](https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/heartbeat/) to learn more.
