---
title: How Cloudflare prevents email-based phishing attacks · Cloudflare
  Learning Paths
description: Cloudflare Email Security uses a variety of factors to determine
  whether a given email message attachment, URL, or specific network traffic is
  part of a phishing campaign.
lastUpdated: 2025-02-21T10:05:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-o365-email/concepts/prevent-phishing-attack/
  md: https://developers.cloudflare.com/learning-paths/secure-o365-email/concepts/prevent-phishing-attack/index.md
---

Cloudflare Email Security uses a variety of factors to determine whether a given email message attachment, URL, or specific network traffic is part of a phishing campaign.

These small pattern assessments are dynamic in nature. Cloudflare's automated systems use a combination of factors to clearly distinguish between a valid phishing campaign and benign traffic.

Cloudflare's vast global network detects emergent campaign infrastructure and aggregates data for Cloudflare's proprietary analytics engine SPARSE.

SPARSE uses AI and ML models to make effective detections for all types of malicious emails, including Business Email Compromise (BEC).

In a BEC attack, the attacker falsifies an email message to trick the victim into performing some action - most often transferring money to an account or location the attacker controls.

To detect these low volume, malicious emails that do not contain malware, malicious links or email attachments, Cloudflare analyzes the email thread, content, sentiment and context via message lexical analysis, subject analysis and sender analysis. Display names are also compared with known executive names for similarity using several matching models.

Refer to [How we detect phish](https://developers.cloudflare.com/email-security/reference/how-we-detect-phish/#sample-attack-types-and-detections) to learn more about additional attack types and detections.
