---
title: Define device enrollment permissions · Cloudflare Learning Paths
description: Device enrollment permissions determine which users can connect new
  devices to your organization's Cloudflare Zero Trust instance. Once the user
  registers their device, the WARP client will store their identity token and
  use it to authenticate to services in your private network.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/device-enrollment-permissions/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/device-enrollment-permissions/index.md
---

Device enrollment permissions determine which users can connect new devices to your organization's Cloudflare Zero Trust instance. Once the user registers their device, the WARP client will store their identity token and use it to authenticate to services in your private network.

## Set device enrollment permissions

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

  2. In **Device enrollment permissions**, select **Manage**.

  3. In the **Policies** tab, configure one or more [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) to define who can join their device. For example, you could allow all users with a company email address:

     | Rule type | Selector | Value |
     | - | - | - |
     | Include | Emails ending in | `@company.com` |

  Note

  Device posture checks are not supported in device enrollment policies. WARP can only perform posture checks after the device is enrolled.

  1. In the **Login methods** tab:

     a. Select the [identity providers](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) users can authenticate with. If you have not integrated an identity provider, you can use the [one-time PIN](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/one-time-pin/).

     b. (Optional) If you plan to only allow access via a single IdP, turn on **Instant Auth**. End users will not be shown the Cloudflare Access login page. Instead, Cloudflare will redirect users directly to your SSO login event.

  2. Select **Save**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Apps and Policies Write`

  2. Create a reusable Access policy using the [`cloudflare_zero_trust_access_policy`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_policy) resource:

     ```tf
     resource "cloudflare_zero_trust_access_policy" "allow_company_emails" {
       account_id   = var.cloudflare_account_id
       name         = "Allow company emails"
       decision     = "allow"
       include      = [
         {
           email_domain = {
             domain = "@example.com"
           }
         }
       ]
     }
     ```

  3. Use the [`cloudflare_zero_trust_access_application`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_application) resource to create an application with type `warp`.

     ```tf
     resource "cloudflare_zero_trust_access_application" "device_enrollment" {
       account_id       = var.cloudflare_account_id
       type             = "warp"
       name             = "Warp device enrollment"
       allowed_idps              = [cloudflare_zero_trust_access_identity_provider.microsoft_entra_id.id]
       auto_redirect_to_identity = true
       app_launcher_visible      = false
       policies = [
         {
           id = cloudflare_zero_trust_access_policy.allow_company_emails.id
           precedence = 1
         }
       ]
     }
     ```

## Only allow corporate devices

Device posture evaluation happens after a device has already enrolled in your Zero Trust organization. If you want only specific devices to be able to enroll, we recommend adding a [mutual TLS authentication](https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/) rule to your device enrollment policy. This rule will check for the presence of a specific client certificate on the enrolling devices.

Note

Mutual TLS authentication is only available on Enterprise plans.

Certificate requirements

* The CA certificate can be from a publicly trusted CA or self-signed.

* In the certificate `Basic Constraints`, the attribute `CA` must be set to `TRUE`.

* The certificate must use one of the signature algorithms listed below:

  Allowed signature algorithms

  `x509.SHA1WithRSA`

  `x509.SHA256WithRSA`

  `x509.SHA384WithRSA`

  `x509.SHA512WithRSA`

  `x509.ECDSAWithSHA1`

  `x509.ECDSAWithSHA256`

  `x509.ECDSAWithSHA384`

  `x509.ECDSAWithSHA512`

To check for an mTLS certificate:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Access** > **Service auth** > **Mutual TLS**.

  2. Select **Add mTLS Certificate**.

  3. Enter any name for the root CA.

  4. In **Certificate content**, paste the contents of your root CA.

     If the client certificate is directly signed by the root CA, you only need to upload the root. If the client certificate is signed by an intermediate certificate, you must upload the entire CA chain (intermediate and root). For example:

     ```txt
     -----BEGIN CERTIFICATE-----
     <intermediate.pem>
     -----END CERTIFICATE-----
     -----BEGIN CERTIFICATE-----
     <rootCA.pem>
     -----END CERTIFICATE-----
     ```

  1) In **Associated hostnames**, enter your Zero Trust team domain: `<team-name>.cloudflareaccess.com`

  2) In your [device enrollment permissions](#set-device-enrollment-permissions), add a *Common Name* or *Valid Certificate* rule. For example, the following policy requires a client certificate with a specific common name:

     | Action | Rule type | Selector | Value |
     | - | - | - | - |
     | Allow | Require | Common Name | `<CERT-COMMON-NAME>` |

  3) On your device, add the client certificate to the [system keychain](https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/#test-in-the-browser).

* Terraform (v5)

  1. Add the following permissions to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Mutual TLS Certificates Write`
     * `Access: Apps and Policies Write`

  2. Use the [`cloudflare_zero_trust_access_mtls_certificate`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_mtls_certificate) resource to add an mTLS certificate to your account:

     ```tf
     resource "cloudflare_zero_trust_access_mtls_certificate" "example_mtls_cert" {
       account_id     = var.cloudflare_account_id
       name           = "WARP enrollment mTLS cert"
       certificate    = <<EOT
       -----BEGIN CERTIFICATE-----
       xxxx
       xxxx
       -----END CERTIFICATE-----
       EOT
       associated_hostnames = ["your-team-name.cloudflareaccess.com"]
     }
     ```

  3. Create the following Access policy:

     ```tf
     resource "cloudflare_zero_trust_access_policy" "warp_enrollment_mtls" {
       account_id     = var.cloudflare_account_id
       name           = "Allow employees with mTLS cert"
       decision       = "allow"
       include = [
         {
           email_domain = {
             domain = "@example.com"
           }
         }
       ]


       require = [
         {
           common_name = {
             common_name = "Common name 1"
           }
         },
             {
           common_name = {
             common_name = "Common name 2"
           }
         }
       ]
     }
     ```

  4. Add the policy to your [`cloudflared_zero_trust_access_application` for WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/device-enrollment/#set-device-enrollment-permissions).

  5. On your device, add the client certificate to the [system keychain](https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/#test-in-the-browser).

## Best practices

Most businesses use a single identity provider as the source of truth for their user directory. You should use this source of truth to onboard your corporate users to Zero Trust, for example by requiring company email addresses to login with your primary identity provider. Later on, you can add other login methods or identity providers as necessary for any contractors, vendors, or acquired corporations who may need access to your network.
