---
title: Upload via custom path · Cloudflare Images docs
description: You can use a custom ID path to upload an image instead of the path
  automatically generated by Cloudflare Images’ Universal Unique Identifier
  (UUID).
lastUpdated: 2025-04-07T16:12:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/images/upload-images/upload-custom-path/
  md: https://developers.cloudflare.com/images/upload-images/upload-custom-path/index.md
---

You can use a custom ID path to upload an image instead of the path automatically generated by Cloudflare Images’ Universal Unique Identifier (UUID).

Custom paths support:

* Up to 1,024 characters.
* Any number of subpaths.
* The [UTF-8 encoding standard](https://en.wikipedia.org/wiki/UTF-8) for characters.

Note

Images with custom ID paths cannot be made private using [signed URL tokens](https://developers.cloudflare.com/images/manage-images/serve-images/serve-private-images). Additionally, when [serving images](https://developers.cloudflare.com/images/manage-images/serve-images/), any `%` characters present in Custom IDs must be encoded to `%25` in the image delivery URLs.

Make a `POST` request using the example below as reference. You can use custom ID paths when you upload via a URL or with a direct file upload.

```bash
curl --request POST https://api.cloudflare.com/client/v4/accounts/{account_id}/images/v1 \
--header "Authorization: Bearer <API_TOKEN>" \
--form 'url=https://<REMOTE_PATH_TO_IMAGE>' \
--form 'id=<PATH_TO_YOUR_IMAGE>'
```

After successfully uploading the image, you will receive a response similar to the example below.

```json
{
  "result": {
    "id": "<PATH_TO_YOUR_IMAGE>",
    "filename": "<YOUR_IMAGE>",
    "uploaded": "2022-04-20T09:51:09.559Z",
    "requireSignedURLs": false,
    "variants": ["https://imagedelivery.net/Vi7wi5KSItxGFsWRG2Us6Q/<PATH_TO_YOUR_IMAGE>/public"]
  },
  "result_info": null,
  "success": true,
  "errors": [],
  "messages": []
}
```
