---
title: Account roles · Cloudflare Fundamentals docs
description: Whenever you add a new member to your account, you can assign
  policies to those users and make use of the available roles. Roles can only
  ever be assigned to their given scope and multiple roles can be assigned to a
  given policy.
lastUpdated: 2025-10-23T04:22:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-members/roles/
  md: https://developers.cloudflare.com/fundamentals/manage-members/roles/index.md
---

Whenever you [add a new member](https://developers.cloudflare.com/fundamentals/manage-members/manage/) to your account, you can assign policies to those users and make use of the available roles. Roles can only ever be assigned to their given scope and multiple roles can be assigned to a given policy.

## Account-scoped roles

Account-scoped roles apply across an entire Cloudflare account, and through all domains in that account.

| Role | Description |
| - | - |
| Administrator | Can access the full account and edit subscriptions. Cannot manage memberships nor billing profile. |
| Super Administrator - All Privileges | Can edit any Cloudflare setting, make purchases, update billing, and manage memberships. Super Administrators can revoke the access of other Super Administrators. |
| Administrator Read Only | Can access the full account in read-only mode. |
| Analytics | Can read Analytics. |
| API Gateway | Grants full access to [API Gateway (including API Shield)](https://developers.cloudflare.com/api-shield/) for all domains in an account. |
| API Gateway Read | Grants read access to [API Gateway (including API Shield)](https://developers.cloudflare.com/api-shield/) for all domains in an account. |
| Audit Logs Viewer | Can view [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/). |
| Bot Management (Account-wide) | Can edit [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/) (including [Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/)) configurations for all domains in account. |
| Billing | Can edit the account's [billing profile](https://developers.cloudflare.com/billing/create-billing-profile/) and subscriptions |
| Cloudflare Access | Can edit [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) and [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/). |
| Cache Purge | Can purge the edge cache and allows the reading of zone settings. |
| Cloudflare DEX | Can edit [Cloudflare DEX](https://developers.cloudflare.com/cloudflare-one/insights/dex/). |
| Cloudflare Gateway | Can edit [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) and read [Access](https://developers.cloudflare.com/cloudflare-one/identity/). |
| Cloudflare Images | Can access [Cloudflare Images](https://developers.cloudflare.com/images/) data. |
| Cloudflare R2 Admin | Can edit Cloudflare [R2](https://developers.cloudflare.com/r2/) buckets, objects, and associated configurations. |
| Cloudflare R2 Read | Can read Cloudflare [R2](https://developers.cloudflare.com/r2/) buckets, objects, and associated configurations. |
| Cloudflare Stream | Can edit [Cloudflare Stream](https://developers.cloudflare.com/stream/) media. |
| Cloudflare Zero Trust | Can edit [Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/). Grants administrator access to all Zero Trust products including Access, Gateway, WARP, Tunnel, Browser Isolation, CASB, DLP, DEX, and Email Security. |
| Cloudflare Zero Trust DNS Locations Write | Can view [Gateway DNS locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/#secure-dns-locations) and create and edit [secure DNS locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/#secure-dns-locations). |
| Cloudflare Zero Trust PII | Can access [Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/) PII. |
| Cloudflare Zero Trust Read Only | Can access [Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/) read only mode. |
| Cloudflare Zero Trust Reporting | Can access [Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/) reporting data. |
| DNS | Can edit [DNS records](https://developers.cloudflare.com/dns/manage-dns-records/). |
| Email Configuration Admin | Grants administrator access to Email Security. Cannot take actions on emails, or read emails. |
| Email Integration Admin | Grants read and write access to integrations only. |
| Email Security Analyst | Grants analyst access. Can take action on emails and read emails. |
| Email Security Read Only | Grants read only access to all of Email Security. |
| Email Security Reporting | Grants read access to Email Security metrics. |
| Email Security Policy Admin | Grants read access to all settings, and write access to [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/allow-policies/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/trusted-domains/), and [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/blocked-senders/) |
| Firewall | Can edit [WAF](https://developers.cloudflare.com/waf/), [IP Access rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/), [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/) settings, and [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/). |
| Load Balancer | Can edit [Load Balancers](https://developers.cloudflare.com/load-balancing/), Pools, Origins, and Health Checks. |
| Log Share | Can edit [Log Share](https://developers.cloudflare.com/logs/) configuration. |
| Log Share Reader | Can read Enterprise [Log Share](https://developers.cloudflare.com/logs/). |
| Magic Network Monitoring | Can view and edit [MNM configuration](https://developers.cloudflare.com/magic-network-monitoring/). |
| Magic Network Monitoring Admin | Can view, edit, create, and delete [MNM configuration](https://developers.cloudflare.com/magic-network-monitoring/). |
| Magic Network Monitoring Read-Only | Can view [MNM configuration](https://developers.cloudflare.com/magic-network-monitoring/). |
| Network Services Write (Magic) | Grants write access to network configurations for Magic services. Magic Tunnel health checks require the Analytics role for non-admin users. |
| Network Services Read (Magic) | Grants read access to network configurations for Magic services. Magic Tunnel health checks require the Analytics role for non-admin users. |
| Minimal Account Access | Can view account, and nothing else. |
| Page Shield | Grants write access to [Page Shield](https://developers.cloudflare.com/page-shield/) across the whole account. |
| Page Shield Read | Grants read access to [Page Shield](https://developers.cloudflare.com/page-shield/) across the whole account. |
| Hyperdrive Read | Grants read access to [Hyperdrive](https://developers.cloudflare.com/hyperdrive/) database configuration. |
| Hyperdrive Admin | Grants write access to [Hyperdrive](https://developers.cloudflare.com/hyperdrive/) database configuration. |
| SSL/TLS, Caching, Performance, Page Rules, and Customization | Can edit most Cloudflare settings except for [DNS](https://developers.cloudflare.com/dns/) and [Firewall](https://developers.cloudflare.com/waf/). |
| Secrets Store Admin | Can create, edit, duplicate, delete, and view secrets metadata. Can also [add a Secrets Store binding to a Worker](https://developers.cloudflare.com/secrets-store/integrations/workers/). |
| Secrets Store Deployer | Can view secrets metadata but cannot create, edit, duplicate, nor delete secrets. Can also [add a Secrets Store binding to a Worker](https://developers.cloudflare.com/secrets-store/integrations/workers/). |
| Secrets Store Reporter | Can view secrets metadata. Cannot perform any actions (create, edit, duplicate, delete secrets), nor add a Secrets Store binding to a Worker. |
| Security Center Brand Protection | Can access the Brand Protection feature on the API and Cloudflare dashboard. Brand Protection role also gives you access to the Investigate platform. |
| Security Center Cloudforce One Admin | Grants write access to [Cloudforce One](https://developers.cloudflare.com/security-center/cloudforce-one/). |
| Security Center Cloudforce One Read | Grants read access to [Cloudforce One](https://developers.cloudflare.com/security-center/cloudforce-one/), and cannot create and/or edit RFIs or PIRs. |
| Trust and Safety | Can access trust and safety related services. |
| Turnstile | Grants full access to [Turnstile](https://developers.cloudflare.com/turnstile/). |
| Turnstile Read | Grants read access to [Turnstile](https://developers.cloudflare.com/turnstile/). |
| Vectorize Admin | Can edit [Vectorize](https://developers.cloudflare.com/vectorize/) configurations. |
| Vectorize Read only | Can read [Vectorize](https://developers.cloudflare.com/vectorize/) configurations. |
| Waiting Room Admin | Can edit [Waiting Room](https://developers.cloudflare.com/waiting-room/) configuration. |
| Waiting Room Read | Can read [Waiting Room](https://developers.cloudflare.com/waiting-room/) configuration. |
| Workers Platform Admin | Grants edit and read access to all products typically used as part of Cloudflare's Developer Platform, including [Workers](https://developers.cloudflare.com/workers/), [Pages](https://developers.cloudflare.com/pages/), [Durable Objects](https://developers.cloudflare.com/durable-objects/), [KV](https://developers.cloudflare.com/kv/), [R2](https://developers.cloudflare.com/r2/), Zones, [Zone Analytics](https://developers.cloudflare.com/analytics/account-and-zone-analytics/zone-analytics/) and [Page Rules](https://developers.cloudflare.com/rules/). Cloudflare may add additional read-only permissions to this role as new products are introduced. |
| Workers Platform (Read-only) | Grants read-only access to all products typically used as part of Cloudflare's Developer Platform, including [Workers](https://developers.cloudflare.com/workers/), [Pages](https://developers.cloudflare.com/pages/), [Durable Objects](https://developers.cloudflare.com/durable-objects/), [KV](https://developers.cloudflare.com/kv/), [R2](https://developers.cloudflare.com/r2/), Zones, [Zone Analytics](https://developers.cloudflare.com/analytics/account-and-zone-analytics/zone-analytics/) and [Page Rules](https://developers.cloudflare.com/rules/). Cloudflare may add additional read-only permissions to this role as new products are introduced. |
| Zaraz Admin | Can edit and publish [Zaraz](https://developers.cloudflare.com/zaraz/) configuration. |
| Zaraz Edit | Can edit [Zaraz](https://developers.cloudflare.com/zaraz/) configuration. |
| Zaraz Read | Can read [Zaraz](https://developers.cloudflare.com/zaraz/) configuration. |
| Zone Versioning (Account-Wide) | Can view and edit [Zone Versioning](https://developers.cloudflare.com/version-management/) for all domains in account. |
| Zone Versioning Read (Account-Wide) | Can view [Zone Versioning](https://developers.cloudflare.com/version-management/) for all domains in account. |

## Domain-scoped roles

Domain-scoped roles apply for a given domain within an account.

| Role | Description |
| - | - |
| Bot Management | Can edit [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/) (including [Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/)) configurations. |
| Cache Domain Purge | Grants access to [purge the edge cache](https://developers.cloudflare.com/cache/how-to/purge-cache/) for a specific domain and allows the reading of zone settings. |
| Domain Administrator | Grants full access to domains in an account, and read-only access to account-wide [Firewall](https://developers.cloudflare.com/waf/account/managed-rulesets/deploy-dashboard/), [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/), and [Worker](https://developers.cloudflare.com/workers/) resources. |
| Domain Administrator Read Only | Grants read-only access to domains in an account, as well as account-wide [Firewall](https://developers.cloudflare.com/waf/account/managed-rulesets/deploy-dashboard/), [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/), and [Worker](https://developers.cloudflare.com/workers/) resources. |
| Domain API Gateway | Grants full access to API Gateway (including [API Shield](https://developers.cloudflare.com/api-shield/)). |
| Domain API Gateway Read | Grants read access to API Gateway (including [API Shield](https://developers.cloudflare.com/api-shield/)). |
| Domain DNS | Grants access to edit [DNS settings](https://developers.cloudflare.com/dns/) for domains in an account. |
| Domain Page Shield | Grants write access to [Page Shield](https://developers.cloudflare.com/page-shield/) for domains in an account. |
| Domain Page Shield Read | Grants read access to [Page Shield](https://developers.cloudflare.com/page-shield/) for domains in an account. |
| Domain Waiting Room Admin | Can edit [waiting rooms](https://developers.cloudflare.com/waiting-room/) configuration. |
| Domain Waiting Room Read | Can read [waiting rooms](https://developers.cloudflare.com/waiting-room/) configuration. |
| Zone Versioning | Grants full access to [Zone Versioning](https://developers.cloudflare.com/version-management/). |
| Zone Versioning Read | Grants read-only access to [Zone Versioning](https://developers.cloudflare.com/version-management/). |

## Resource-scoped roles

Resource-scoped roles apply for a specific resource within an account.

Note

Resource-scoped roles is currently in Beta.

| Role | Description |
| - | - |
| Cloudflare Access App Admin | Grants full access to a specific Access Application in an account. |
| Cloudflare Access Identity Provider Admin | Grants full access to a specific Access identity provider(IdP) in an account. |
| Access for Infrastructure Target Admin | Grants full access to a specific Access for Infrastructure. Target in an account |
