---
title: Overview · Cloudflare Email Routing docs
description: Cloudflare Email Routing is designed to simplify the way you create
  and manage email addresses, without needing to keep an eye on additional
  mailboxes. With Email Routing, you can create any number of custom email
  addresses to use in situations where you do not want to share your primary
  email address, such as when you subscribe to a new service or newsletter.
  Emails are then routed to your preferred email inbox, without you ever having
  to expose your primary email address.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-routing/
  md: https://developers.cloudflare.com/email-routing/index.md
---

Create custom email addresses for your domain and route incoming emails to your preferred mailbox.

Available on all plans

Cloudflare Email Routing is designed to simplify the way you create and manage email addresses, without needing to keep an eye on additional mailboxes. With Email Routing, you can create any number of custom email addresses to use in situations where you do not want to share your primary email address, such as when you subscribe to a new service or newsletter. Emails are then routed to your preferred email inbox, without you ever having to expose your primary email address.

Email Routing is free and private by design. Cloudflare will not store or access the emails routed to your inbox.

It is available to all Cloudflare customers [using Cloudflare as an authoritative nameserver](https://developers.cloudflare.com/dns/zone-setups/full-setup/).

***

## Features

### Email Workers

Leverage the power of Cloudflare Workers to implement any logic you need to process your emails. Create rules as complex or simple as you need.

[Use Email Workers](https://developers.cloudflare.com/email-routing/email-workers/)

### Custom addresses

With Email Routing you can have many custom email addresses to use for specific situations.

[Use Custom addresses](https://developers.cloudflare.com/email-routing/get-started/enable-email-routing/)

### Analytics

Email Routing includes metrics to help you check on your email traffic history.

[Use Analytics](https://developers.cloudflare.com/email-routing/get-started/email-routing-analytics/)

***

## Related products

**[Email Security](https://developers.cloudflare.com/cloudflare-one/email-security/)**

Cloudflare Email Security is a cloud based service that stops phishing attacks, the biggest cybersecurity threat, across all traffic vectors - email, web and network.

**[DNS](https://developers.cloudflare.com/dns/)**

Email Routing is available to customers using Cloudflare as an authoritative nameserver.
