---
title: Remote browser isolation · Cloudflare Zero Trust docs
description: Cloudflare Browser Isolation complements the Secure Web Gateway and
  Zero Trust Network Access solutions by executing active webpage content in a
  secure isolated browser. Executing active content remotely from the endpoint
  protects users from zero-day attacks and malware. In addition to protecting
  endpoints, Browser Isolation also protects users from phishing attacks by
  preventing user input on risky websites and controlling data transmission to
  sensitive web applications. You can further filter isolated traffic with
  Gateway HTTP and DNS policies.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/
  md: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/index.md
---

Cloudflare Browser Isolation complements the [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) and [Zero Trust Network Access](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) solutions by executing active webpage content in a secure isolated browser. Executing active content remotely from the endpoint protects users from zero-day attacks and malware. In addition to protecting endpoints, Browser Isolation also protects users from phishing attacks by preventing user input on risky websites and controlling data transmission to sensitive web applications. You can further filter isolated traffic with Gateway [HTTP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/) and [DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/) policies.

Remote browsing is invisible to the user who continues to use their browser normally without changing their preferred browser and habits. Every open tab and window is automatically isolated. When the user closes the isolated browser, their session is automatically deleted.

Note

Available as an add-on to Zero Trust Pay-as-you-go and Enterprise plans.

## Privacy

Cloudflare Browser Isolation is a security product. In order to serve transparent isolated browsing and block web based threats our network decrypts Internet traffic using the [Cloudflare root CA](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/). Traffic logs are retained as per the [Zero Trust](https://developers.cloudflare.com/cloudflare-one/insights/logs/) documentation.
