---
title: Connect private network to WARP clients · Cloudflare Zero Trust docs
description: This guide covers how to connect WARP client user devices to a
  private network behind WARP Connector. In this example, we will create a WARP
  Connector for subnet 10.0.0.0/24 and install it on 10.0.0.1.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/user-to-site/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/user-to-site/index.md
---

This guide covers how to connect WARP client user devices to a private network behind WARP Connector. In this example, we will create a WARP Connector for subnet `10.0.0.0/24` and install it on `10.0.0.1`.

```mermaid
    flowchart LR
      subgraph subnet1[Subnet 10.0.0.0/24]
				router1["WARP Connector
        10.0.0.1"]--> device1["Device
        10.0.0.2"]
      router1["WARP Connector
        10.0.0.1"]
      end
      W[WARP clients]-->C((Cloudflare))-->router1
```

## Prerequisites

* A Linux host [1](#user-content-fn-1) on the subnet.
* For WARP Connector to connect to Cloudflare services, your firewall should allow inbound/outbound traffic for the [WARP IP addresses, ports, and domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).
* For WARP clients to connect to your subnet, your firewall should allow inbound traffic from the WARP CGNAT IP range: `100.96.0.0/12`

## 1. Install a WARP Connector

To install WARP Connector on a host machine:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Networks** > **Tunnels**.

2. Select **Create a tunnel**.

3. For the tunnel type, select **WARP Connector**.

4. You will be prompted to turn on **Warp to Warp** and [**Override local interface IP**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#override-local-interface-ip) if they are currently turned off. These settings allow Cloudflare to assign a unique CGNAT IP to each WARP device and route traffic between them.

5. Give the tunnel any name (for example, `Subnet-10.0.0.0/24`) and select **Create tunnel**.

6. Select the operating system of your host machine.

7. On your host machine, open a terminal window and run the commands shown in the Zero Trust dashboard. Those commands will install the WARP Connector, enable IP forwarding on the host, and connect WARP Connector to your Zero Trust organization.

   Remote SSH connections

   If you are managing the deployment remotely over SSH, your connection may drop when you install the WARP Connector. Because the WARP connector immediately starts forwarding traffic to Cloudflare, the remote SSH server's traffic will now route via Cloudflare instead of via the server's public IP. To work around the issue:

   * **Option 1**: In your WARP Connector [device profile](#2-recommended-create-a-device-profile), temporarily add the public IP of your local machine to the [Split Tunnel Exclude list](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).

   * **Option 2**: If your local machine is connected to Zero Trust (for example, via the WARP client), you can SSH to the CGNAT IP of the WARP Connector. Traffic to the CGNAT IP must route through the WARP tunnel.

8. (Optional) Configure IP forwarding:

   Enable IP forwarding to persist after reboot

   ```sh
   echo 'net.ipv4.ip_forward = 1' | sudo tee -a /etc/sysctl.d/99-warp-svc.conf
   sudo sysctl -p /etc/sysctl.d/99-warp-svc.conf
   ```

   Configure IP forwarding with iptables

   If you are setting up WARP Connector on a host with iptables enabled, make sure that your iptables FORWARD chain includes rules to accept the desired traffic. For testing and troubleshooting purposes, you can set the default policy for the WARP interface to ACCEPT:

   ```sh
   iptables -A FORWARD -i CloudflareWARP -J ACCEPT
   iptables -A FORWARD -o CloudflareWARP -J ACCEPT
   ```

9. To verify that the WARP Connector is connected to Cloudflare:

   ```sh
   $ warp-cli status
   Status update: Connected
   ```

   Troubleshoot connection

   If WARP is disconnected, try the following troubleshooting strategies:

   * Run `warp-cli connect`.

   * If your private network uses a firewall to restrict Internet traffic, ensure that it allows the [WARP ports and IPs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

   * Review your [WARP daemon logs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/) for information about why the connection is failing.

WARP Connector software is now installed but not yet routing traffic.

## 2. (Recommended) Create a device profile

A dedicated [device profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/) allows you to manage the WARP Connector host machine separately from WARP client user devices. WARP Connector hosts are registered to your Zero Trust organization with the email address `warp_connector@<your-team-name>.cloudflareaccess.com`. To set up a device profile for WARP Connector:

1. [Create a new profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/#create-a-new-profile) that matches on the following expression:

   | Selector | Operator | Value |
   | - | - | - |
   | User email | is | `warp_connector@<your-team-name>.cloudflareaccess.com` |

2. In the profile settings, ensure that **Service mode** is set to **Gateway with WARP**.

Note

`warp_connector@<your-team-name>.cloudflareaccess.com` will only match WARP Connectors deployed with WARP client version `2024.9.346.0` and above. WARP Connectors deployed using the legacy workflow will use the generic email for service token registrations (`non-identity@<your-team-name>.cloudflareaccess.com`).

## 3. Route CGNAT IPs through Cloudflare

WARP clients and WARP Connectors are accessed using their CGNAT IP. Therefore, CGNAT IP traffic must route through Cloudflare on both the WARP Connector host and WARP client devices.

1. In your WARP Connector device profile, go to [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).
2. Ensure that `100.96.0.0/12` routes through the WARP tunnel. For example, if you are using **Exclude** mode, delete `100.64.0.0/10` from the list and re-add `100.64.0.0/11` and `100.112.0.0/12`.
3. Repeat the previous steps for all WARP client device profiles.

## 4. Route traffic from subnet to WARP Connector

Depending on where you installed the WARP Connector, you may need to configure other devices on the subnet to route requests through WARP Connector.

### Option 1: Default gateway

If you installed WARP Connector on your router, no additional configuration is necessary. All traffic will use the router as the default gateway.

![Default gateway routing configuration](https://developers.cloudflare.com/_astro/default-gateway.BVYB18Ze_Z1PhWIA.webp)

### Option 2: Alternate gateway

If you have access to the router but installed WARP Connector on another machine, you can configure the router to forward traffic to the WARP Connector. This typically involves adding a static route for the destination IPs that you want to connect to through Cloudflare. Refer to your router documentation for specific instructions on how to add an IP route.

![Alternate gateway routing configuration](https://developers.cloudflare.com/_astro/alternate-gateway.qFF4NOVp_Z2mO45W.webp)

#### Add IP route to router

`100.96.0.0/12` is the default CIDR for all user devices running the [WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/). On your router, add a rule that routes the destination IP `100.96.0.0/12` to the WARP Connector host machine (`10.0.0.100`).

When a device on the subnet sends a request, the router will first redirect the traffic to the WARP Connector host. WARP Connector encrypts the traffic, changes its destination IP to the [WARP ingress IP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#warp-ingress-ip), and sends it back to the router. The router will now forward this encrypted traffic to Cloudflare.

Note

Ensure that your routing rules do not forward the [WARP ingress IP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#warp-ingress-ip) back to the WARP Connector.

### Option 3: Intermediate gateway

If you do not have access to the router, you will need to configure each device on the subnet to egress through the WARP Connector machine instead of the default gateway.

![Intermediate gateway routing configuration](https://developers.cloudflare.com/_astro/intermediate-gateway.RihbfwSx_2pXfUQ.webp)

#### Add IP route to devices

To route all CGNAT IP traffic through WARP Connector:

* Linux

  ```sh
  sudo ip route add 100.96.0.0/12 via <WARP-CONNECTOR-IP> dev eth0
  ```

* macOS

  ```sh
  sudo route -n add -net 100.96.0.0/12 <WARP-CONNECTOR-IP>
  ```

* Windows

  ```bash
  route /p add 100.96.0.0/12 mask 255.255.255.255 <WARP-CONNECTOR-IP>
  ```

To validate subnet routing, [check your routing table](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#routing-table) and ensure that traffic is routing through the `CloudflareWARP` [virtual interface](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#virtual-interface).

## 5. Test the WARP Connector

You can now send a request from a WARP client user device to a device behind WARP connector. For example, on the WARP client device run `ping 10.0.0.2`.

```mermaid
    flowchart LR
      subgraph subnet1[Subnet 10.0.0.0/24]
				router1["WARP Connector
        10.0.0.1"]--> device1["Device
        10.0.0.2"]
      router1["WARP Connector
        10.0.0.1"]
      end
      W[WARP client]--ping 10.0.0.2 -->C((Cloudflare))-->router1
```

## Footnotes

1. Check the [system requirements](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/#linux). Package dependencies are the following: `curl`, `gpg`, `iptables`, `iptables-persistent`, `lsb-core`, and `sudo`.

   [↩](#user-content-fnref-1)
