---
title: Microsoft Endpoint Manager · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can integrate with Microsoft to require that
  users connect to certain applications from managed devices. This
  service-to-service posture check uses the WARP client to read endpoint data
  from Microsoft. Devices are identified by their serial numbers. If multiple
  devices have the same serial number, Cloudflare cannot accurately match a WARP
  device with a third-party provider device. You must ensure that each of your
  devices has a unique serial number.
lastUpdated: 2025-10-23T02:03:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/microsoft/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/microsoft/index.md
---

Cloudflare Zero Trust can integrate with Microsoft to require that users connect to certain applications from managed devices. This service-to-service posture check uses the WARP client to read endpoint data from Microsoft. Devices are identified by their serial numbers. If multiple devices have the same serial number, Cloudflare cannot accurately match a WARP device with a third-party provider device. You must ensure that each of your devices has a unique serial number.

## Prerequisites

Device posture with Microsoft Endpoint Manager requires:

* An Intune license

* Microsoft Endpoint Manager is managing the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Service providers](https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/).

## 1. Obtain Microsoft Graph settings

The following values are required:

* Client secret
* Application (client) ID
* Direct (tenant) ID

To retrieve those values:

1. Log in to your Microsoft Dashboard.
2. Go to **App Registrations** and select **New Registrations**.
3. Copy the `Application (client) ID` value to a safe place. This will be your Client ID.
4. Copy the `Directory (tenant) ID` value to a safe place. This will be your Customer ID.
5. Go to **Certificates & Secrets** and select **New client secret**.
6. Fill in a description and how long the secret should be valid.
7. After completing the form, immediately copy the resulting secret. This will be your Client Secret.
8. Go to **API Permissions** and select **Add permission**.
9. Select **Microsoft Graph**.
10. Select **Application permissions**.
11. Add `DeviceManagementManagedDevices.Read.All`.
12. If the permission status shows **Not granted**, select **Grant admin consent**.

## 2. Add Intune as a service provider

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **Microsoft Endpoint Manager**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) Enter the **Client ID**, **Client secret** and **Customer ID** as you noted down above.
2) Select a **Polling frequency** for how often Cloudflare Zero Trust should query Microsoft Graph API for information.
3) Select **Test and save**.

## 3. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the Microsoft Endpoint Manager provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/identity/devices/#3-build-a-device-posture-policy).

## Device posture attributes

The Microsoft Endpoint Manager device posture check relies on information from the Microsoft Graph API. Refer to Microsoft's [ComplianceState](https://docs.microsoft.com/en-us/graph/api/resources/intune-devices-compliancestate?view=graph-rest-1.0) and [List managedDevices](https://docs.microsoft.com/en-us/graph/api/intune-devices-manageddevice-list?view=graph-rest-1.0) documentation for a list of properties returned by the API.

To learn more about how to control ComplianceState, refer to Microsoft's [compliance policies guide](https://docs.microsoft.com/en-us/mem/intune/protect/device-compliance-get-started).
