---
title: Custom device posture integration · Cloudflare Zero Trust docs
description: Configure custom device posture checks in Cloudflare Zero Trust
  using a service-to-service integration.
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/custom/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/custom/index.md
---

Cloudflare Zero Trust allows you to enforce custom device posture checks on your applications. This involves configuring a WARP service-to-service integration that periodically calls the external API of your choice, whether it is a third-party endpoint provider or a home built solution. When called, the API will receive device identifying information from Cloudflare and be expected to return a value between `0` to `100`. You can then set up a device posture check that determines if the returned value counts as a pass or fail; for example, you could allow access to a user only if their device has a posture value greater than `60`.

```mermaid
sequenceDiagram
    participant WARP
		participant Cloudflare Access
    participant External API
    WARP->>Cloudflare Access: Client ID and Secret
		Cloudflare Access->>External API: Application token
		WARP->>External API: JSON with user and device identity
    External API-->>WARP: JSON with 0-100 result
```

## External API requirements

The custom service provider integration works with any API service that meets the following specifications. For an example of a custom device posture integration API, refer to our [Cloudflare Workers sample code](https://github.com/cloudflare/custom-device-posture-integration-example-worker).

### Authentication

The WARP client authenticates to the external API through Cloudflare Access. The external API should [validate the application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/validating-json/) issued by Cloudflare Access to ensure that any requests which bypass Access (for example, due to a network misconfiguration) are rejected.

### Data passed to external API

Cloudflare will pass the following parameters to the configured API endpoint. You can use this data to identify the device and assign a posture score. For some devices, not all identifying information will apply, in which case the field will be blank. A maximum of 1,000 devices will be sent per a request.

| Field | Description |
| - | - |
| `device_id` | Device UUID assigned by the WARP client |
| `email` | Email address used to authenticate the WARP client |
| `serial_number` | Device serial number |
| `mac_address` | Device MAC address |
| `virtual_ipv4` | Device virtual IPv4 address |
| `hostname` | Device name |

Note

Devices are identified by their serial numbers. You must ensure that each of your devices has a unique serial number. If multiple devices have the same serial number, Cloudflare and your external API will not be able to accurately match them.

Example request body:

```json
{
  "devices": {
    [
      {
        "device_id": "9ece5fab-7398-488a-a575-e25a9a3dec07",
        "email": "jdoe@mycompany.com",
        "serial_number": "jdR44P3d",
        "mac_address": "74:1d:3e:23:e0:fe",
        "virtual_ipv4": "100.96.0.10",
        "hostname": "string",
      },
      {...},
      {...}
    ]
  }
}
```

### Expected response from external API

For each Cloudflare `device_id`, the API service is expected to return a posture score and optionally a third-party device ID.

| Field | Description |
| - | - |
| `s2s_id` | Third party device ID (empty string if unavailable) |
| `score` | Integer value between `0` - `100` |

Example response body:

```json
{
  "result": {
    "9ece5fab-7398-488a-a575-e25a9a3dec07": {
      "s2s_id": "",
      "score": 10
    },
    "device_id2": {...},
    "device_id3": {...}
  }
}
```

## Set up custom device posture checks

### 1. Create a service token

WARP uses an Access Client ID and Access Client Secret to securely authenticate to the external API. If you do not already have an Access Client ID and Access Client Secret, [create a new service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/#create-a-service-token).

### 2. Create an Access application

Next, secure the external API behind Cloudflare Access so that WARP can authenticate with the service token. To add the API endpoint to Access:

1. [Create a self-hosted application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/) for your API endpoint.

2. Add the following Access policy to the application. Make sure that **Action** is set to *Service Auth* (not *Allow*).

   | Action | Rule type | Selector | Value |
   | - | - | - | - |
   | Service Auth | Include | Service Token | `<TOKEN-NAME>` |

### 3. Add a service provider integration

To create a custom service-to-service integration:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **Custom service provider**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) In **Access client ID** and **Access client secret**, enter the Access service token used to authenticate to your external API.
2) In **Rest API URL**, enter the external API endpoint that Cloudflare will query for posture information (for example, `https://api.example.com`). For more information, refer to [External API requirements](#external-api-requirements).
3) In **Polling frequency**, choose how often Cloudflare Zero Trust should query the external API for information.
4) Select **Test and save**. The test checks if Cloudflare can authenticate to the API URL using the provided Access credentials.

Next, [configure a device posture check](#4-configure-the-posture-check) to determine if a given posture score constitutes a pass or fail.

### 4. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the Custom service provider provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/identity/devices/#3-build-a-device-posture-policy).

## Device posture attributes

| Selector | Description | Value |
| - | - | - |
| Score | Posture score returned by external API | `0` to `100` |
