---
title: CrowdStrike · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can integrate with Crowdstrike to require
  that users connect to certain applications from managed devices. This
  service-to-service posture check uses the WARP client to read endpoint data
  from Crowdstrike. Devices are identified by their serial numbers. If multiple
  devices have the same serial number, Cloudflare cannot accurately match a WARP
  device with a third-party provider device. You must ensure that each of your
  devices has a unique serial number.
lastUpdated: 2025-10-23T02:03:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/crowdstrike/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/crowdstrike/index.md
---

Cloudflare Zero Trust can integrate with Crowdstrike to require that users connect to certain applications from managed devices. This service-to-service posture check uses the WARP client to read endpoint data from Crowdstrike. Devices are identified by their serial numbers. If multiple devices have the same serial number, Cloudflare cannot accurately match a WARP device with a third-party provider device. You must ensure that each of your devices has a unique serial number.

## Prerequisites

Device posture with Crowdstrike requires:

* Falcon Enterprise plan or above

* Crowdstrike agent is deployed on the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Service providers](https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/).

## Set up CrowdStrike as a service provider

### 1. Obtain CrowdStrike settings

The following CrowdStrike values are needed to set up the CrowdStrike posture check:

* Client ID
* Client Secret
* Base URL
* Customer ID

To retrieve those values:

1. Log in to your Falcon Dashboard.

2. Go to **Support and resources** > **API Clients and Keys**.

3. Select **Create API client** and enter any name for the client.

4. Turn on the following API permissions:

   | Scope | Permission |
   | - | - |
   | Hosts | Read |
   | Zero Trust Assessment | Read |

5. Select **Create**.

6. Copy the **Client ID**, **Client Secret**, and **Base URL** to a safe place.

7. Go to **Host setup and management** > **Sensor downloads** and copy your **Customer ID**.

### 2. Add CrowdStrike as a service provider

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **Crowdstrike**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) Enter the **Client ID** and **Client secret** you noted down above.
2) In **Rest API URL**, enter your **Base URL**.
3) Enter your **Customer ID**.
4) Choose a **Polling frequency** for how often Cloudflare Zero Trust should query CrowdStrike for information.
5) Select **Test and save**.

### 3. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the Crowdstrike provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/identity/devices/#3-build-a-device-posture-policy).

## Device posture attributes

Device posture data is gathered from the [CrowdStrike Zero Trust Assessment APIs](https://falcon.us-2.crowdstrike.com/documentation/156/zero-trust-assessment-apis). To learn more about how scores are calculated, refer to the [CrowdStrike Zero Trust Assessment](https://falcon.us-2.crowdstrike.com/documentation/138/zero-trust-assessment) documentation.

| Selector | Description | Value |
| - | - | - |
| OS | OS signal score | `1` to `100` |
| Overall | Overall ZTA score | `1` to `100` |
| Sensor config | Sensor signal score | `1` to `100` |
| Version | ZTA score version | `2.1.0` |
| State | Current online status of the device | *Online*, *Offline*, or *Unknown* |
| Last seen | Elapsed time since the device was last seen. Only returned if its state is `online` or `unknown`. | In the last 1 hour, 3 hours, 6 hours, 12 hours, 24 hours, 7 days, 30 days, or more than 30 days |
