---
title: Posture logs · Cloudflare Zero Trust docs
description: Posture logs show the device posture check results reported by the WARP client.
lastUpdated: 2025-10-23T02:03:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/posture-logs/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/posture-logs/index.md
---

Posture logs show the [device posture check](https://developers.cloudflare.com/cloudflare-one/identity/devices/) results reported by the WARP client.

To view device posture logs, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Logs** > **Posture**. Logs will only display if you have configured [device posture checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/) for your Zero Trust organization.

Enterprise users can generate more detailed logs with [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/).

## Explanation of the fields

### Device details

| Field | Description |
| - | - |
| **Name** | Name of the device. |
| **ID** | Device ID generated by the WARP client. |
| **Serial number** | Serial number of the device. |
| **Manufacturer** | Manufacturer of the device. |
| **Model** | Model of the device. |

### User details

| Field | Description |
| - | - |
| **Email** | Email used to register the device with Zero Trust. |
| **User ID** | UUID of the user who registered the device. |
| **Registration ID** | UUID of the user's WARP client registration. |

### Posture details

| Field | Description |
| - | - |
| **Name** | Name of the [device posture check](https://developers.cloudflare.com/cloudflare-one/identity/devices). |
| **Type** | Type of [WARP client check](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/) or [service provider check](https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/). |
| **Rule ID** | UUID of the device posture check. |
| **Conditions met** | Whether the device passed or failed the posture check criteria. Evaluates to `true` if the **Received values** match the **Expected values**. |
| **Expected values** | Values required to pass the device posture check. |
| **Received values** | Posture check values detected by the WARP client. |
