---
title: Disk encryption · Cloudflare Zero Trust docs
description: The Disk Encryption device posture attribute ensures that disks are
  encrypted on a device.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/disk-encryption/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/disk-encryption/index.md
---

The Disk Encryption device posture attribute ensures that disks are encrypted on a device.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/).

## Enable the disk encryption check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **WARP client checks** and select **Add new**.
3. Select **Disk Encryption**.
4. Enter a descriptive name for the check.
5. Select your operating system.
6. Either enable disk encryption for all volumes, or input the specific volume(s) you want to check for encryption (for example, `C`).
7. Select **Save**.

Next, go to **Logs** > **Posture** and verify that the disk encryption check is returning the expected results.

## Validate disk encryption status

The following commands will return the disk encryption status on various operating systems. The results can help you validate if the posture check is working as expected.

### macOS

1. Open a terminal window.

2. Run the `/usr/sbin/system_profiler SPStorageDataType` command to return a list of drivers on the system and note the value of **Mount Point**.

   ```sh
   /usr/sbin/system_profiler SPStorageDataType
   ```

   ```sh
   Storage:


      Data:


        Free: 428.52 GB (428,519,702,528 bytes)
        Capacity: 494.38 GB (494,384,795,648 bytes)
        Mount Point: /System/Volumes/Data
   ```

3. Run the `diskutil info` command for a specific **Mount Point** and look for the value returned for **FileVault**. It must show **Yes** for the disk to be considered encrypted.

   ```sh
   diskutil info /System/Volumes/Data | grep FileVault
   ```

   ```sh
    FileVault:                 Yes
   ```

### Windows

1. Open a PowerShell window.
2. Run the `Get-BitLockerVolume` command to list all volumes detected on the system.
3. **Protection Status** must be set to **On** for the disk to be considered encrypted.

### Linux

List all hard drives on the system:

```sh
lsblk
```

```sh
NAME                        MAJ:MIN RM   SIZE RO TYPE  MOUNTPOINT
nvme0n1                     259:0    0 476.9G  0 disk
├─nvme0n1p1                 259:1    0   512M  0 part  /boot/efi
├─nvme0n1p2                 259:2    0   488M  0 part  /boot
└─nvme0n1p3                 259:3    0   476G  0 part
  └─nvme0n1p3_crypt         253:0    0 475.9G  0 crypt
    ├─my--vg-root   253:1            0 474.9G  0 lvm   /
    └─my--vg-swap_1 253:2            0   976M  0 lvm   [SWAP]
```

On Linux, encryption is reported per mounted partition, not physical drive. In the example above, the root and swap partitions are considered encrypted because they are located within a `crypt` container. The `/boot` and `/boot/efi` partitions remain unencrypted.

### iOS, Android and ChromeOS

These platforms are always encrypted and so no disk encryption check is supported.
