---
title: Common DLP policies · Cloudflare Zero Trust docs
description: The following in-line DLP policies are commonly used to secure data
  in uploaded and downloaded files.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/common-policies/
  md: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/common-policies/index.md
---

The following in-line DLP policies are commonly used to secure data in uploaded and downloaded files.

## Log uploads/downloads

The **Allow** action functions as an implicit logger, providing visibility into where your sensitive data is going without impacting the end user experience. The following example scans for your enabled Financial Information profile entries when users upload or download data to file sharing apps.

| Selector | Operator | Value | Logic | Action |
| - | - | - | - | - |
| DLP Profile | in | *Financial Information* | And | Allow |
| Content Categories | in | *File Sharing* | | |

## Block file types

Block the upload or download of files based on their type.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Upload File Types | in | *Microsoft Office Word Document (docx)* | And | Block |
  | Download File Types | in | *PDF (pdf)* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Block file types",
      "description": "Block the upload or download of files based on their type",
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(http.upload.file.types[*] in {\"docx\"}) and any(http.download.file.types[*] in {\"pdf\"})",
      "identity": "",
      "device_posture": ""
    }'
  ```

For more information on what file formats DLP can scan, refer to [Supported file types](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/#supported-file-types).

## Block uploads/downloads for specific users

You can configure access on a per-user or group basis by adding [identity-based conditions](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/) to your policies. The following example blocks only contractors from uploading/downloading Financial Information to file sharing apps.

| Selector | Operator | Value | Logic | Action |
| - | - | - | - | - |
| DLP Profile | in | *Financial Information* | And | Block |
| Content Categories | in | *File Sharing* | And | |
| User Group Names | in | *Contractors* | | |

## Exclude Android applications

Many Android applications (such as Google Drive) use [certificate pinning](https://developers.cloudflare.com/ssl/reference/certificate-pinning/), which is incompatible with Gateway inspection. If needed, you can create a [Do Not Inspect policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) so that the app can continue to function on Android:

1. Set up an [OS version device posture check](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/os-version/) that checks for the Android operating system.

2. Create the following HTTP policy in Gateway:

   | Selector | Operator | Value | Logic | Action |
   | - | - | - | - | - |
   | Application | in | *Google Drive* | And | Do Not Inspect |
   | Passed Device Posture Checks | in | *OS Version Android* | | |

Android users can now use the app, but the app traffic will bypass DLP scanning.

## Exclude specific sites

In your [DLP logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/#4-view-dlp-logs), you may find that certain sites are a common source of noise. To exempt these sites from DLP scanning:

1. [Create a list](https://developers.cloudflare.com/cloudflare-one/traffic-policies/lists/) of hostnames or URLs.

2. Exclude the list from your DLP policy as shown in the example below:

   | Selector | Operator | Value | Logic | Action |
   | - | - | - | - | - |
   | DLP Profile | in | *Financial Information* | And | Block |
   | Application | in | *Google Drive* | And | |
   | Domain | not in list | *Do not DLP - SSN* | | |
