---
title: Overview · Cloudflare China Network docs
description: The Cloudflare China Network is a package of selected Cloudflare's
  performance and security products running on data centers located in Mainland
  China and operated by Cloudflare's partner JD Cloud.
lastUpdated: 2025-09-25T09:00:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/china-network/
  md: https://developers.cloudflare.com/china-network/index.md
---

The [Cloudflare China Network](https://www.cloudflare.com/china-network/) is a package of selected Cloudflare's performance and security products running on data centers located in Mainland China and operated by Cloudflare's partner JD Cloud.

The data centers cover most populated regions in China. Combining Cloudflare's technological leadership and JD Cloud's local operations expertise, the Cloudflare China Network is designed to meet the needs for secure, reliable, and fast-performing content delivery in China. You can use the same configurations that you use with Cloudflare everywhere else in the world and with the same dashboard experience.

## Main features

The Cloudflare China Network provides:

* A single solution for both performance improvement and security services such as [WAF](https://developers.cloudflare.com/waf/), [DDoS](https://developers.cloudflare.com/ddos-protection/), and [bot management](https://developers.cloudflare.com/bots/).
* An unified experience for managing network traffic and security posture. You can manage all configurations on the same dashboard.
* The same customer support capabilities as Cloudflare's global network. You may also have access to premium service and local language support.
* [In-China Authoritative DNS and in-China nameservers](https://developers.cloudflare.com/china-network/concepts/china-dns/) to improve the Time to First Byte (TTFB) performance.
* [Global Acceleration](https://developers.cloudflare.com/china-network/concepts/global-acceleration/) is a suite of connectivity and performance offerings designed to simplify your global assets' deployment in China.

## Availability

The Cloudflare China Network is available as a separate subscription for customers on an [Enterprise plan](https://www.cloudflare.com/plans/enterprise/).

## Important notes

* Not all Cloudflare products are available in the Cloudflare China Network. Refer to [Available products and features](https://developers.cloudflare.com/china-network/reference/available-products/) for details.
* IPv6 support is mandatory for all Internet entities operating in Mainland China. The Cloudflare China Network feature automatically enables IPv6 for domains to fulfill this requirement.
* All the content inside of Mainland China is monitored by local authorities and must comply with local regulations.
* You must have a valid [ICP (Internet Content Provider) filing or license](https://developers.cloudflare.com/china-network/concepts/icp/) for each apex domain you wish to onboard to Cloudflare.
