---
title: New CASB integrations for ChatGPT, Claude, and Gemini · Changelog
description: Cloudflare CASB now scans ChatGPT, Claude, and Gemini for
  misconfigurations, sensitive data exposure, and compliance issues, helping
  organizations adopt AI with confidence.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-26-casb-ai-integrations/
  md: https://developers.cloudflare.com/changelog/2025-08-26-casb-ai-integrations/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## New CASB integrations for ChatGPT, Claude, and Gemini

Aug 26, 2025

[CASB](https://developers.cloudflare.com/cloudflare-one/applications/casb/)

[Cloudflare CASB](https://www.cloudflare.com/zero-trust/products/casb/) now supports three of the most widely used GenAI platforms — **OpenAI ChatGPT**, **Anthropic Claude**, and **Google Gemini**. These API-based integrations give security teams agentless visibility into posture, data, and compliance risks across their organization’s use of generative AI.

![Cloudflare CASB showing selection of new findings for ChatGPT, Claude, and Gemini integrations.](https://developers.cloudflare.com/_astro/casb-ai-integrations-preview.B-zsSA1P_Z1CkbtH.webp)

#### Key capabilities

* **Agentless connections** — connect ChatGPT, Claude, and Gemini tenants via API; no endpoint software required
* **Posture management** — detect insecure settings and misconfigurations that could lead to data exposure
* **DLP detection** — identify sensitive data in uploaded chat attachments or files
* **GenAI-specific insights** — surface risks unique to each provider’s capabilities

#### Learn more

* [ChatGPT integration docs](https://developers.cloudflare.com/cloudflare-one/applications/casb/casb-integrations/openai/)
* [Claude integration docs](https://developers.cloudflare.com/cloudflare-one/applications/casb/casb-integrations/anthropic/)
* [Gemini integration docs](https://developers.cloudflare.com/cloudflare-one/applications/casb/casb-integrations/google-workspace/gemini/)

These integrations are available to all Cloudflare One customers today.
