---
title: Run AI-generated code on-demand with Code Sandboxes (new) · Changelog
description: You can start creating sandboxes today by installing our new Sandbox package.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-24-announcing-sandboxes/
  md: https://developers.cloudflare.com/changelog/2025-06-24-announcing-sandboxes/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Run AI-generated code on-demand with Code Sandboxes (new)

Jun 25, 2025

[Agents ](https://developers.cloudflare.com/agents/)[Workers ](https://developers.cloudflare.com/workers/)[Workflows](https://developers.cloudflare.com/workflows/)

AI is supercharging app development for everyone, but we need a safe way to run untrusted, LLM-written code. We’re introducing [Sandboxes](https://www.npmjs.com/package/@cloudflare/sandbox), which let your Worker run actual processes in a secure, container-based environment.

```ts
import { getSandbox } from "@cloudflare/sandbox";
export { Sandbox } from "@cloudflare/sandbox";


export default {
  async fetch(request: Request, env: Env) {
    const sandbox = getSandbox(env.Sandbox, "my-sandbox");
    return sandbox.exec("ls", ["-la"]);
  },
};
```

#### Methods

* `exec(command: string, args: string[], options?: { stream?: boolean })`:Execute a command in the sandbox.
* `gitCheckout(repoUrl: string, options: { branch?: string; targetDir?: string; stream?: boolean })`: Checkout a git repository in the sandbox.
* `mkdir(path: string, options: { recursive?: boolean; stream?: boolean })`: Create a directory in the sandbox.
* `writeFile(path: string, content: string, options: { encoding?: string; stream?: boolean })`: Write content to a file in the sandbox.
* `readFile(path: string, options: { encoding?: string; stream?: boolean })`: Read content from a file in the sandbox.
* `deleteFile(path: string, options?: { stream?: boolean })`: Delete a file from the sandbox.
* `renameFile(oldPath: string, newPath: string, options?: { stream?: boolean })`: Rename a file in the sandbox.
* `moveFile(sourcePath: string, destinationPath: string, options?: { stream?: boolean })`: Move a file from one location to another in the sandbox.
* `ping()`: Ping the sandbox.

Sandboxes are still experimental. We're using them to explore how isolated, container-like workloads might scale on Cloudflare — and to help define the developer experience around them.

You can try it today from your Worker, with just a few lines of code. Let us know what you build.
