---
title: npm i agents · Changelog
description: Install the latest version of the `agents` SDK to build multi-agent
  applications, use the new RPC API, and visit the latest documentation updates.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-18-npm-i-agents/
  md: https://developers.cloudflare.com/changelog/2025-03-18-npm-i-agents/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## npm i agents

Mar 18, 2025

[Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

![npm i agents](https://developers.cloudflare.com/_astro/npm-i-agents.CXCpJ1-7.apng)

#### `agents-sdk` -> `agents` Updated

📝 **We've renamed the Agents package to `agents`**!

If you've already been building with the Agents SDK, you can update your dependencies to use the new package name, and replace references to `agents-sdk` with `agents`:

```sh
# Install the new package
npm i agents
```

```sh
# Remove the old (deprecated) package
npm uninstall agents-sdk


# Find instances of the old package name in your codebase
grep -r 'agents-sdk' .
# Replace instances of the old package name with the new one
# (or use find-replace in your editor)
sed -i 's/agents-sdk/agents/g' $(grep -rl 'agents-sdk' .)
```

All future updates will be pushed to the new `agents` package, and the older package has been marked as deprecated.

#### Agents SDK updates New

We've added a number of big new features to the Agents SDK over the past few weeks, including:

* You can now set `cors: true` when using `routeAgentRequest` to return permissive default CORS headers to Agent responses.
* The regular client now syncs state on the agent (just like the React version).
* `useAgentChat` bug fixes for passing headers/credentials, including properly clearing cache on unmount.
* Experimental `/schedule` module with a prompt/schema for adding scheduling to your app (with evals!).
* Changed the internal `zod` schema to be compatible with the limitations of Google's Gemini models by removing the discriminated union, allowing you to use Gemini models with the scheduling API.

We've also fixed a number of bugs with state synchronization and the React hooks.

* JavaScript

  ```js
  // via https://github.com/cloudflare/agents/tree/main/examples/cross-domain
  export default {
    async fetch(request, env) {
      return (
        // Set { cors: true } to enable CORS headers.
        (await routeAgentRequest(request, env, { cors: true })) ||
        new Response("Not found", { status: 404 })
      );
    },
  };
  ```

* TypeScript

  ```ts
  // via https://github.com/cloudflare/agents/tree/main/examples/cross-domain
  export default {
    async fetch(request: Request, env: Env) {
      return (
        // Set { cors: true } to enable CORS headers.
        (await routeAgentRequest(request, env, { cors: true })) ||
        new Response("Not found", { status: 404 })
      );
    },
  } satisfies ExportedHandler<Env>;
  ```

#### Call Agent methods from your client code New

We've added a new [`@unstable_callable()`](https://developers.cloudflare.com/agents/api-reference/agents-api/) decorator for defining methods that can be called directly from clients. This allows you call methods from within your client code: you can call methods (with arguments) and get native JavaScript objects back.

* JavaScript

  ```js
  // server.ts
  import { unstable_callable, Agent } from "agents";
  export class Rpc extends Agent {
    // Use the decorator to define a callable method
    @unstable_callable({
      description: "rpc test",
    })
    async getHistory() {
      return this.sql`SELECT * FROM history ORDER BY created_at DESC LIMIT 10`;
    }
  }
  ```

* TypeScript

  ```ts
  // server.ts
  import { unstable_callable, Agent, type StreamingResponse } from "agents";
  import type { Env } from "../server";


   export class Rpc extends Agent<Env> {
     // Use the decorator to define a callable method
     @unstable_callable({
       description: "rpc test",
     })
     async getHistory() {
       return this.sql`SELECT * FROM history ORDER BY created_at DESC LIMIT 10`;
     }
  }
  ```

#### agents-starter Updated

We've fixed a number of small bugs in the [`agents-starter`](https://github.com/cloudflare/agents-starter) project — a real-time, chat-based example application with tool-calling & human-in-the-loop built using the Agents SDK. The starter has also been upgraded to use the latest [wrangler v4](https://developers.cloudflare.com/changelog/2025-03-13-wrangler-v4/) release.

If you're new to Agents, you can install and run the `agents-starter` project in two commands:

```sh
# Install it
$ npm create cloudflare@latest agents-starter -- --template="cloudflare/agents-starter"
# Run it
$ npm run start
```

You can use the starter as a template for your own Agents projects: open up `src/server.ts` and `src/client.tsx` to see how the Agents SDK is used.

#### More documentation Updated

We've heard your feedback on the Agents SDK documentation, and we're shipping more API reference material and usage examples, including:

* Expanded [API reference documentation](https://developers.cloudflare.com/agents/api-reference/), covering the methods and properties exposed by the Agents SDK, as well as more usage examples.
* More [Client API](https://developers.cloudflare.com/agents/api-reference/agents-api/#client-api) documentation that documents `useAgent`, `useAgentChat` and the new `@unstable_callable` RPC decorator exposed by the SDK.
* New documentation on how to [call agents](https://developers.cloudflare.com/agents/api-reference/calling-agents/) and (optionally) authenticate clients before they connect to your Agents.

Note that the Agents SDK is continually growing: the type definitions included in the SDK will always include the latest APIs exposed by the `agents` package.

If you're still wondering what Agents are, [read our blog on building AI Agents on Cloudflare](https://blog.cloudflare.com/build-ai-agents-on-cloudflare/) and/or visit the [Agents documentation](https://developers.cloudflare.com/agents/) to learn more.
