---
title: Default Cache Behavior · Cloudflare Cache (CDN) docs
description: Cloudflare respects the origin web server’s cache headers in the
  following order unless an Edge Cache TTL cache rule overrides the headers.
  Refer to the Edge TTL section for details on default TTL behavior.
lastUpdated: 2025-09-11T09:13:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/concepts/default-cache-behavior/
  md: https://developers.cloudflare.com/cache/concepts/default-cache-behavior/index.md
---

Cloudflare respects the origin web server’s cache headers in the following order unless an [Edge Cache TTL cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/settings/#edge-ttl) overrides the headers. Refer to the [Edge TTL](https://developers.cloudflare.com/cache/how-to/configure-cache-status-code/#edge-ttl) section for details on default TTL behavior.

* Cloudflare **does not** cache the resource when:

  * The `Cache-Control` header is set to `private`, `no-store`, `no-cache`, or `max-age=0`.
  * The [Set-Cookie header](https://developers.cloudflare.com/cache/concepts/cache-behavior/#interaction-of-set-cookie-response-header-with-cache) exists.
  * The HTTP request method is anything other than a `GET`.

* Cloudflare **does** cache the resource when:

  * The `Cache-Control` header is set to `public` and `max-age` is greater than 0.
  * The `Expires` header is set to a future date.

Note

Cloudflare does cache the resource even if there is no `Cache-Control` header based on [status codes](https://developers.cloudflare.com/cache/how-to/configure-cache-status-code/#edge-ttl).

Note

If both `max-age` and an `Expires` header are set, `max-age` will be used by Cloudflare.

When [Origin Cache Control](https://developers.cloudflare.com/cache/concepts/cache-control/) is enabled on an Enterprise customer’s website, it indicates that Cloudflare should strictly respect `Cache-Control` directives received from the origin server. Free, Pro and Business customers have this feature enabled by default. For a list of directives and behaviors when Origin Cache-Control is enabled or disabled, refer to [Cache-Control directives](https://developers.cloudflare.com/cache/concepts/cache-control/#cache-control-directives).

## Client side range requests

Clients can send range requests to be served from the cache using the `Range` header. Note that:

* If the origin response includes a `Content-Length` header, then the specified byte range will be returned with an [HTTP 206](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/2xx-success/#206-partial-content) response.
* If the origin response does not include the `Content-Length` header, the cache will return the full content with an HTTP 200 response.

## Default cached file extensions

Cloudflare only caches based on file extension and not by MIME type. The Cloudflare CDN does not cache HTML or JSON by default. Additionally, by default Cloudflare caches a website's robots.txt.

| | | | | | | |
| - | - | - | - | - | - | - |
| 7Z | CSV | GIF | MIDI | PNG | TIF | ZIP |
| AVI | DOC | GZ | MKV | PPT | TIFF | ZST |
| AVIF | DOCX | ICO | MP3 | PPTX | TTF | |
| APK | DMG | ISO | MP4 | PS | WEBM | |
| BIN | EJS | JAR | OGG | RAR | WEBP | |
| BMP | EOT | JPG | OTF | SVG | WOFF | |
| BZ2 | EPS | JPEG | PDF | SVGZ | WOFF2 | |
| CLASS | EXE | JS | PICT | SWF | XLS | |
| CSS | FLAC | MID | PLS | TAR | XLSX | |

To cache additional content, refer to [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) to create a rule to cache everything.

## Customization options and limits

Cloudflare’s CDN provides several cache customization options:

* Caching behavior for individual URLs via [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/)
* Customize caching with [Cloudflare Workers](https://developers.cloudflare.com/workers/reference/how-the-cache-works/)
* Adjust caching level, cache TTL, and more via the Cloudflare Caching app

### Upload limits

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Max upload size | 100 MB | 100 MB | 200 MB | 500+ MB |

Customers can reduce the **Maximum Upload Size** from the zone's **Network** page.

If you require a larger upload, you can group requests into smaller chunks, upload the full resource through an [unproxied (grey-clouded) DNS record](https://developers.cloudflare.com/dns/proxy-status/) or [upgrade your plan](https://developers.cloudflare.com/billing/change-plan/).

### Cacheable size limits

Cloudflare cacheable file limits:

* Free, Pro and Business customers have a limit of 512 MB.
* For Enterprise customers the default maximum cacheable file size is 5 GB. Contact your account team to request a limit increase.

## When does Cloudflare cache successfully?

The connection status between visitors and Cloudflare can vary, affecting whether Cloudflare caches the content or not. If Cloudflare has already established a connection to the origin and started fetching the content, it will continue to retrieve and cache the entire content, even if the visitor disconnects midway. However, if a visitor disconnects before the origin responds to Cloudflare's request, no content will have been fetched yet, so Cloudflare will not start caching the content.
