---
title: Error responses · Cloudflare Analytics docs
description: The GraphQL Analytics API is a RESTful API based on HTTPS requests
  and JSON responses, and will return familiar HTTP status codes (for example,
  404, 500, 504). However, in contrast to the common REST approach, a 200
  response can contain an error, conforming to the GraphQL specification.
lastUpdated: 2025-06-23T09:00:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/graphql-api/errors/
  md: https://developers.cloudflare.com/analytics/graphql-api/errors/index.md
---

The GraphQL Analytics API is a RESTful API based on HTTPS requests and JSON responses, and will return familiar HTTP status codes (for example, `404`, `500`, `504`). However, in contrast to the common REST approach, a `200` response can contain an error, conforming to the [GraphQL specification](https://graphql.github.io/graphql-spec/June2018/#sec-Errors).

All responses contain an `errors` array, which will be `null` if there are no errors, and include at least one error object if there was an error. Non-null error objects will contain the following fields:

* `message`: a string describing the error.
* `path`: the nodes associated with the error, starting from the root. Note that the number included in the path array, for example, `0` or `1`, specifies to which zone the error applies; `0` indicates the first zone in the list (or only zone, if only one is being queried).
* `timestamp`: UTC datetime when the error occurred.

## Example

```json
{
  "data": null,
  "errors": [
    {
      "message": "cannot request data older than 2678400s",
      "path": ["viewer", "zones", "0", "firewallEventsAdaptiveGroups"],
      "extensions": {
        "timestamp": "2019-12-09T21:27:19.195060142Z"
      }
    }
  ]
}
```

## Common error types

### Dataset accessibility limits exceeded

Sample error messages:

* "cannot request data older than..."
* "number of fields cannot be more than..."
* "does not have access to the path..."
* "not available for your plan. Upgrade to..."

These messages indicate that the query exceeds what is allowed for the particular dataset under the current [plan](https://www.cloudflare.com/plans/), and an upgrade should be considered. Refer to [Node limits](https://developers.cloudflare.com/analytics/graphql-api/limits/#node-limits-and-availability) for details.

### Parsing issues

Sample error messages:

* "error parsing args..."
* "scalar fields must have not selections"

These messages indicate that the query cannot be processed because it is malformed.

### Rate limits exceeded

Sample error messages:

* "limit reached, please try reduced time period"
* "quota exceeded, please repeat your request in the next minute"
* "rate limiter budget depleted, try again after 5 minutes"

Refer to the [Limits](https://developers.cloudflare.com/analytics/graphql-api/limits/) section for more details about rate limits.
