---
title: Data Loss Prevention (DLP) · Cloudflare AI Gateway docs
description: Data Loss Prevention (DLP) for AI Gateway helps protect your
  organization from inadvertent exposure of sensitive data through AI
  interactions. By integrating with Cloudflare's proven DLP technology, AI
  Gateway can scan both incoming prompts and outgoing AI responses for sensitive
  information, ensuring your AI applications maintain security and compliance
  standards.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ai-gateway/features/dlp/
  md: https://developers.cloudflare.com/ai-gateway/features/dlp/index.md
---

Data Loss Prevention (DLP) for AI Gateway helps protect your organization from inadvertent exposure of sensitive data through AI interactions. By integrating with Cloudflare's proven DLP technology, AI Gateway can scan both incoming prompts and outgoing AI responses for sensitive information, ensuring your AI applications maintain security and compliance standards.

## How it works

AI Gateway DLP leverages the same powerful detection engines used in [Cloudflare's Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/) solution to scan AI traffic in real-time. The system analyzes both user prompts sent to AI models and responses received from AI providers, identifying sensitive data patterns and taking appropriate protective actions.

## Key benefits

* **Prevent data leakage**: Stop sensitive information from being inadvertently shared with AI providers or exposed in AI responses
* **Maintain compliance**: Help meet regulatory requirements like GDPR, HIPAA, and PCI DSS
* **Consistent protection**: Apply the same DLP policies across all AI providers and models
* **Audit visibility**: Comprehensive logging and reporting for security and compliance teams
* **Zero-code integration**: Enable protection without modifying existing AI applications

## Supported AI traffic

AI Gateway DLP can scan:

* **User prompts** - Content submitted to AI models, including text, code, and structured data
* **AI responses** - Output generated by AI models before being returned to users

The system works with all AI providers supported by AI Gateway, providing consistent protection regardless of which models or services you use.

## Integration with Cloudflare DLP

AI Gateway DLP uses the same detection profiles and policies as Cloudflare's enterprise DLP solution. This means:

* **Unified management** - Configure DLP policies once and apply them across web traffic, email, SaaS applications, and AI interactions
* **Consistent detection** - The same sensitive data patterns are detected across all channels
* **Centralized reporting** - All DLP events appear in the same dashboard and logs
* **Shared profiles** - Reuse existing DLP detection profiles for AI traffic

For more information about Cloudflare's DLP capabilities, refer to the [Data Loss Prevention documentation](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

## Getting started

To enable DLP for your AI Gateway:

1. [Set up DLP policies](https://developers.cloudflare.com/ai-gateway/features/dlp/set-up-dlp/) for your AI Gateway
2. Configure detection profiles and response actions
3. Monitor DLP events through the Cloudflare dashboard

## Related resources

* [Set up DLP for AI Gateway](https://developers.cloudflare.com/ai-gateway/features/dlp/set-up-dlp/)
* [Cloudflare Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)
* [AI Gateway Security Features](https://developers.cloudflare.com/ai-gateway/features/guardrails/)
* [DLP Detection Profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/)
